/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine.project;

import com.mulesoft.tools.migration.engine.project.structure.JavaProject;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeMavenApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeMavenDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreePolicy;
import com.mulesoft.tools.migration.project.ProjectType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ProjectTypeFactory {
    private DocumentBuilder db;

    public ProjectTypeFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        dbf.setValidating(false);
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public ProjectType getProjectType(Path projectPath) throws Exception {
        if (Files.exists(projectPath.resolve(MuleThreeMavenApplication.srcMainConfigurationPath), new LinkOption[0]) && Files.exists(projectPath.resolve("pom.xml"), new LinkOption[0])) {
            return ProjectType.MULE_THREE_MAVEN_APPLICATION;
        }
        if (Files.exists(projectPath.resolve(MuleThreeMavenDomain.srcMainConfigurationPath), new LinkOption[0]) && Files.exists(projectPath.resolve("pom.xml"), new LinkOption[0])) {
            return ProjectType.MULE_THREE_MAVEN_DOMAIN;
        }
        if (Files.exists(projectPath.resolve(MuleThreeApplication.srcMainConfigurationPath), new LinkOption[0]) && FileUtils.listFiles((File)projectPath.resolve(MuleThreeApplication.srcMainConfigurationPath).toFile(), (String[])new String[]{"xml"}, (boolean)false).stream().filter(f -> this.rootElement((File)f, "mule")).count() > 0L) {
            return ProjectType.MULE_THREE_APPLICATION;
        }
        if (Files.exists(projectPath.resolve(MuleThreeDomain.srcMainConfigurationPath), new LinkOption[0]) && FileUtils.listFiles((File)projectPath.resolve(MuleThreeDomain.srcMainConfigurationPath).toFile(), (String[])new String[]{"xml"}, (boolean)false).stream().filter(f -> this.rootElement((File)f, "domain:mule-domain")).count() > 0L) {
            return ProjectType.MULE_THREE_DOMAIN;
        }
        if (MuleThreePolicy.isPolicyInFolder(projectPath)) {
            return ProjectType.MULE_THREE_POLICY;
        }
        if (Files.exists(projectPath.resolve(MuleFourApplication.srcMainConfigurationPath), new LinkOption[0])) {
            return ProjectType.MULE_FOUR_APPLICATION;
        }
        if (Files.exists(projectPath.resolve(MuleFourDomain.srcMainConfigurationPath), new LinkOption[0])) {
            return ProjectType.MULE_FOUR_DOMAIN;
        }
        if (Files.exists(projectPath.resolve(JavaProject.srcMainJavaPath), new LinkOption[0])) {
            return ProjectType.JAVA;
        }
        return ProjectType.BASIC;
    }

    private boolean rootElement(File configFile, String expectedRootTag) {
        Document doc;
        try {
            doc = this.db.parse(configFile);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        return expectedRootTag.equals(doc.getDocumentElement().getTagName());
    }
}

