/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.report;

import com.mulesoft.tools.migration.exception.MigrationAbortException;
import com.mulesoft.tools.migration.project.ProjectType;
import com.mulesoft.tools.migration.report.html.model.ReportEntryModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.yaml.snakeyaml.Yaml;

public class DefaultMigrationReport
implements MigrationReport {
    private transient Map<String, Map<String, Map<String, Object>>> possibleEntries;
    private transient XMLOutputter outp = new XMLOutputter();
    private final Set<ReportEntryModel> reportEntries = new HashSet<ReportEntryModel>();
    private String projectType;
    private String projectName;
    private double successfulMigrationRatio;
    private double errorMigrationRatio;
    private int processedElements;

    public DefaultMigrationReport() {
        this.possibleEntries = new HashMap<String, Map<String, Map<String, Object>>>();
        try {
            for (URL reportYamlUrl : Collections.list(DefaultMigrationReport.class.getClassLoader().getResources("report.yaml"))) {
                InputStream yamlStream = reportYamlUrl.openStream();
                Throwable throwable = null;
                try {
                    this.possibleEntries.putAll((Map)new Yaml().loadAs(yamlStream, Map.class));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (yamlStream == null) continue;
                    if (throwable != null) {
                        try {
                            yamlStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    yamlStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new MigrationAbortException("Couldn't load report entries definitions.", (Exception)e);
        }
    }

    public void initialize(ProjectType projectType, String projectName) {
        this.projectType = projectType.name();
        this.projectName = projectName;
    }

    public void report(String entryKey, Element element, Element elementToComment, String ... messageParams) {
        String[] splitEntryKey = entryKey.split("\\.");
        Map<String, Object> entryData = this.possibleEntries.get(splitEntryKey[0]).get(splitEntryKey[1]);
        MigrationReport.Level level = MigrationReport.Level.valueOf((String)((String)entryData.get("type")));
        String message = (String)entryData.get("message");
        for (String messageParam : messageParams) {
            message = message.replaceFirst("\\{\\w*\\}", messageParam);
        }
        List docLinks = entryData.get("docLinks") != null ? (List)entryData.get("docLinks") : Collections.emptyList();
        this.report(level, element, elementToComment, message, docLinks.toArray(new String[docLinks.size()]));
    }

    public void report(MigrationReport.Level level, Element element, Element elementToComment, String message, String ... documentationLinks) {
        ReportEntryModel reportEntry;
        int i = 0;
        if (elementToComment != null && this.reportEntries.add(reportEntry = elementToComment.getDocument() != null || element.getDocument() == null ? new ReportEntryModel(level, elementToComment, message, documentationLinks) : new ReportEntryModel(level, elementToComment, message, element.getDocument(), documentationLinks)) && elementToComment != null) {
            elementToComment.addContent(i++, (Content)new Comment("Migration " + level.name() + ": " + message));
            if (documentationLinks.length > 0) {
                elementToComment.addContent(i++, (Content)new Comment("    For more information refer to:"));
                for (String link : documentationLinks) {
                    elementToComment.addContent(i++, (Content)new Comment("        * " + link));
                }
            }
            if (element != elementToComment) {
                XmlDslUtils.removeNestedComments((Element)element);
                elementToComment.addContent(i++, (Content)new Comment(this.outp.outputString(element)));
            }
        }
    }

    public void addProcessedElements(int processedElements) {
        this.processedElements += processedElements;
        this.successfulMigrationRatio = 1.0 * (double)((long)this.processedElements - this.reportEntries.stream().filter(re -> re.getElement() != null && !"compatibility".equals(re.getElement().getNamespacePrefix())).map(re -> re.getElement()).distinct().count()) / (double)this.processedElements;
        this.errorMigrationRatio = 1.0 * (double)this.reportEntries.stream().filter(re -> re.getElement() != null && MigrationReport.Level.ERROR.equals((Object)re.getLevel())).map(re -> re.getElement()).distinct().count() / (double)this.processedElements;
    }

    public void updateReportEntryFilePath(Path oldFileName, Path newFileName) {
        this.reportEntries.stream().filter(e -> oldFileName.toString().equals(e.getFilePath())).forEach(r -> r.setFilePath(newFileName.toString()));
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<ReportEntryModel> getReportEntries() {
        return new ArrayList<ReportEntryModel>(this.reportEntries);
    }

    public double getSuccessfulMigrationRatio() {
        return this.successfulMigrationRatio;
    }

    public double getErrorMigrationRatio() {
        return this.errorMigrationRatio;
    }
}

