/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit.steps;

import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class ApikitApiLocation
implements ProjectStructureContribution {
    static final String MULE_3_API_FOLDER = "src" + File.separator + "main" + File.separator + "api";
    static final String MULE_4_API_FOLDER = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "api";

    public String getDescription() {
        return "Move '" + MULE_3_API_FOLDER + "' content to '" + MULE_4_API_FOLDER + "'";
    }

    public void execute(Path basePath, MigrationReport report) throws RuntimeException {
        File mule3ApiFolder = basePath.resolve(MULE_3_API_FOLDER).toFile();
        File mule4ApiFolder = basePath.resolve(MULE_4_API_FOLDER).toFile();
        try {
            if (mule3ApiFolder.exists()) {
                FileUtils.moveDirectory((File)mule3ApiFolder, (File)mule4ApiFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot move api folder", e);
        }
    }
}

