/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.throttling;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.throttling.AbstractThrottlingMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.throttling.ThrottlingPomContributionMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.QuotaExceededOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.QuotaExceededQueuingLimitReachedOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class FixedTimeFrameAlgorithmMigrationStep
extends AbstractThrottlingMigrationStep {
    private static final String FIXED_TIME_FRAME_ALGORITHM_TAG_NAME = "fixed-time-frame-algorithm";
    private static final String DELAY_TIME_IN_MILLIS_ATTR_NAME = "delayTimeInMillis";
    private static final String DELAY_ATTEMPTS_ATTR_NAME = "delayAttempts";
    private static final String CONFIG_NAME_ATTR_VALUE_RATE_LIMIT = "rateLimitConfig";
    private static final String CONFIG_NAME_ATTR_VALUE_THROTTLING = "throttlingConfig";
    private static final String QUEUING_LIMIT_ATTR_NAME = "queuingLimit";
    private static final String FIVE = "5";
    private static final String EXPLICIT_TAG_NAME = "explicit";
    private static final String KEYS_TAG_NAME = "keys";
    private static final String KEY_TAG_NAME = "key";
    private static final String TIERS_TAG_NAME = "tiers";
    private static final String TIER_TAG_NAME = "tier";
    private static final String ID_ATTR_VALUE_RATE_LIMIT = "{{policyId}}-rate-limit";
    private static final String ID_ATTR_VALUE_THROTTLING = "{{policyId}}-throttle";
    private static final String REATTEMPTS_ATTR_NAME = "reattempts";
    private static final String REATTEMPTS_DELAY_ATTR_NAME = "reattemptsDelay";

    public FixedTimeFrameAlgorithmMigrationStep() {
        super(GatewayNamespaces.THROTTLING_GW_MULE_3_NAMESPACE, FIXED_TIME_FRAME_ALGORITHM_TAG_NAME);
    }

    private boolean isRateLimitMigration(Element fixedTimeFrameAlgorithmElement, MigrationReport migrationReport) {
        Element parentElement = fixedTimeFrameAlgorithmElement.getParentElement();
        Element discardResponseElement = parentElement.getChild("discard-response", GatewayNamespaces.THROTTLING_GW_MULE_3_NAMESPACE);
        if (discardResponseElement == null) {
            Element delayResponseElement = parentElement.getChild("delay-response", GatewayNamespaces.THROTTLING_GW_MULE_3_NAMESPACE);
            if (delayResponseElement != null && fixedTimeFrameAlgorithmElement.getChildren("rate-limit", GatewayNamespaces.THROTTLING_GW_MULE_3_NAMESPACE).size() > 1) {
                migrationReport.report("throttling.throttlingMultipleTiersNotSupported", fixedTimeFrameAlgorithmElement, fixedTimeFrameAlgorithmElement, new String[0]);
                return true;
            }
            return false;
        }
        return true;
    }

    private Element getTiersElement(Element fixedTimeFrameAlgorithmElement) {
        Element tiersElement = new Element(TIERS_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
        this.detachContent(fixedTimeFrameAlgorithmElement.getContent()).forEach(c -> {
            if (c instanceof Element && ((Element)c).getName().equals("rate-limit")) {
                Element rateLimitElement = (Element)c;
                rateLimitElement.setName(TIER_TAG_NAME);
                rateLimitElement.setNamespace(GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
            }
            tiersElement.addContent(c);
        });
        return tiersElement;
    }

    private boolean configElementAttributesAreCorrect(Element configElement, boolean isRateLimitMigration) {
        if (isRateLimitMigration) {
            return configElement.getAttributeValue("name").equals(CONFIG_NAME_ATTR_VALUE_RATE_LIMIT) && configElement.getAttributeValue("clusterizable").equals("true");
        }
        return configElement.getAttributeValue("name").equals(CONFIG_NAME_ATTR_VALUE_THROTTLING) && configElement.getAttributeValue("clusterizable").equals("false") && configElement.getAttributeValue(QUEUING_LIMIT_ATTR_NAME).equals(FIVE);
    }

    private boolean configElementExists(Element rootElement, boolean isRateLimitMigration) {
        List configElements = rootElement.getChildren("config", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
        return configElements.stream().filter(configElement -> {
            Element explicitElement;
            Element tierProviderElement;
            if (configElement != null && this.configElementAttributesAreCorrect((Element)configElement, isRateLimitMigration) && (tierProviderElement = configElement.getChild("tier-provider", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE)) != null && (explicitElement = tierProviderElement.getChild(EXPLICIT_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE)) != null) {
                return explicitElement.getChild(isRateLimitMigration ? KEYS_TAG_NAME : TIERS_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE) != null;
            }
            return false;
        }).findAny().orElse(null) != null;
    }

    private void addConfigElement(Element fixedTimeFrameAlgorithmElement, boolean isRateLimitMigration) {
        Element rootElement = this.getRootElement(fixedTimeFrameAlgorithmElement);
        if (!this.configElementExists(rootElement, isRateLimitMigration)) {
            Element explicitElement = new Element(EXPLICIT_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
            Element configElement = new Element("config", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).setAttribute("name", isRateLimitMigration ? CONFIG_NAME_ATTR_VALUE_RATE_LIMIT : CONFIG_NAME_ATTR_VALUE_THROTTLING).setAttribute("clusterizable", isRateLimitMigration ? "true" : "false").addContent((Content)new Element("tier-provider", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).addContent((Content)explicitElement));
            if (isRateLimitMigration) {
                explicitElement.addContent((Content)new Element(KEYS_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).addContent((Content)new Element(KEY_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).addContent((Content)this.getTiersElement(fixedTimeFrameAlgorithmElement))));
            } else {
                configElement.setAttribute(QUEUING_LIMIT_ATTR_NAME, FIVE);
                explicitElement.addContent((Content)this.getTiersElement(fixedTimeFrameAlgorithmElement));
            }
            rootElement.addContent((Content)configElement);
        }
    }

    private Element getOperationElement(Element fixedTimeFrameAlgorithmElement, boolean isRateLimitMigration) {
        Element element;
        if (isRateLimitMigration) {
            element = new Element("rate-limit", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
            element.setAttribute("id", ID_ATTR_VALUE_RATE_LIMIT);
            element.setAttribute("config-ref", CONFIG_NAME_ATTR_VALUE_RATE_LIMIT);
        } else {
            element = new Element("throttle", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
            Element delayResponseElement = fixedTimeFrameAlgorithmElement.getParentElement().getChild("delay-response", GatewayNamespaces.THROTTLING_GW_MULE_3_NAMESPACE);
            element.setAttribute(REATTEMPTS_ATTR_NAME, delayResponseElement.getAttributeValue(DELAY_ATTEMPTS_ATTR_NAME));
            element.setAttribute(REATTEMPTS_DELAY_ATTR_NAME, delayResponseElement.getAttributeValue(DELAY_TIME_IN_MILLIS_ATTR_NAME));
            element.setAttribute("id", ID_ATTR_VALUE_THROTTLING);
            element.setAttribute("config-ref", CONFIG_NAME_ATTR_VALUE_THROTTLING);
        }
        element.setAttribute("target", "throttlingResponse");
        return element;
    }

    private void addOnErrorContinueElement(Element errorHandlerElement, boolean isRateLimitMigration) {
        if (isRateLimitMigration) {
            new QuotaExceededOnErrorContinueElementWriter().create(errorHandlerElement, true);
        } else {
            new QuotaExceededQueuingLimitReachedOnErrorContinueElementWriter().create(errorHandlerElement, true);
        }
    }

    private void completeTryElementWithOperationContent(Element tryElement, Element fixedTimeFrameAlgorithmElement, boolean isRateLimitMigration) {
        tryElement.addContent(0, (Content)this.getOperationElement(fixedTimeFrameAlgorithmElement, isRateLimitMigration));
        this.addAddHeadersElement(tryElement);
        Element errorHandlerElement = tryElement.getChild("error-handler", GatewayNamespaces.MULE_4_POLICY_NAMESPACE);
        if (errorHandlerElement == null) {
            errorHandlerElement = new Element("error-handler", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
            this.addOnErrorContinueElement(errorHandlerElement, isRateLimitMigration);
            errorHandlerElement.addContent((Content)this.getOnErrorPropagateElement());
            tryElement.addContent((Content)errorHandlerElement);
        } else {
            this.addOnErrorContinueElement(errorHandlerElement, isRateLimitMigration);
            this.addOnErrorPropagateElement(errorHandlerElement);
        }
    }

    private void addOperationElements(Element fixedTimeFrameAlgorithmElement, boolean isRateLimitMigration, MigrationReport migrationReport) {
        Element source = this.setUpHttpPolicy(fixedTimeFrameAlgorithmElement, false, migrationReport);
        Element tryElement = source.getChild("try", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
        if (tryElement == null) {
            tryElement = new Element("try", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
            List<Content> sourceCloneContentList = this.detachContent(source.getContent());
            source.addContent((Content)tryElement);
            sourceCloneContentList.forEach(arg_0 -> ((Element)tryElement).addContent(arg_0));
        }
        this.completeTryElementWithOperationContent(tryElement, fixedTimeFrameAlgorithmElement, isRateLimitMigration);
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        boolean isRateLimitMigration = this.isRateLimitMigration(element, migrationReport);
        this.addConfigElement(element, isRateLimitMigration);
        this.addOperationElements(element, isRateLimitMigration, migrationReport);
        this.addNamespaceDeclarations(element);
        new ThrottlingPomContributionMigrationStep(false).execute((PomModel)this.getApplicationModel().getPomModel().get(), migrationReport);
    }
}

