/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.utils;

import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class PolicyYamlMigrationStep
implements ProjectStructureContribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyYamlMigrationStep.class);
    private static final String YAML_EXTENSION = ".yaml";
    private static final String YML_EXTENSION = ".yml";
    private static final String DEFAULT_POLICY_YAML_VALUE_MESSAGE = "basicStructure.defaultPolicyYamlValue";
    private static final String DEFAULT_POLICY_CONFIGURATION_YAML_VALUE_MESSAGE = "basicStructure.defaultPolicyConfigurationYamlValue";

    public String getDescription() {
        return "Adds properties to policy YAML";
    }

    private void checkYamlProperty(Map<String, Object> yamlData, String key, Object defaultValue, MigrationReport migrationReport, String reportMessage) {
        if (!yamlData.containsKey(key)) {
            yamlData.put(key, defaultValue);
            migrationReport.report(reportMessage, null, null, new String[]{key, defaultValue.toString()});
        }
    }

    private void checkConfigurationProperty(Map<String, Object> configurationProperty, MigrationReport migrationReport) {
        this.checkYamlProperty(configurationProperty, "propertyName", "propertyName", migrationReport, DEFAULT_POLICY_CONFIGURATION_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(configurationProperty, "type", "string", migrationReport, DEFAULT_POLICY_CONFIGURATION_YAML_VALUE_MESSAGE);
    }

    private void checkConfiguration(Map<String, Object> yamlData, MigrationReport migrationReport) {
        this.checkYamlProperty(yamlData, "configuration", new ArrayList(), migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        List configuration = (List)yamlData.get("configuration");
        configuration.forEach(configElement -> this.checkConfigurationProperty((Map<String, Object>)configElement, migrationReport));
    }

    private void treatYaml(File yamlFile, MigrationReport migrationReport) throws IOException {
        Yaml yaml = new Yaml();
        LinkedHashMap<String, Object> yamlData = new LinkedHashMap<String, Object>();
        yamlData.putAll((Map)yaml.loadAs((InputStream)new FileInputStream(yamlFile), Map.class));
        this.checkYamlProperty(yamlData, "id", yamlFile.getName(), migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "name", yamlFile.getName(), migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "description", yamlFile.getName(), migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "category", "Compliance", migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "type", "system", migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "resourceLevelSupported", false, migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "standalone", true, migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "requiredCharacteristics", new ArrayList(), migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkYamlProperty(yamlData, "providedCharacteristics", new ArrayList(), migrationReport, DEFAULT_POLICY_YAML_VALUE_MESSAGE);
        this.checkConfiguration(yamlData, migrationReport);
        yaml.dump(yamlData, (Writer)new FileWriter(yamlFile));
    }

    public void execute(Path path, MigrationReport migrationReport) throws RuntimeException {
        File projectBasePath = path.toFile();
        if (projectBasePath.exists()) {
            File[] yamlFiles = projectBasePath.listFiles((FilenameFilter)new SuffixFileFilter(new String[]{YAML_EXTENSION, YML_EXTENSION}));
            if (yamlFiles.length == 1) {
                try {
                    this.treatYaml(yamlFiles[0], migrationReport);
                }
                catch (IOException e) {
                    migrationReport.report("basicStructure.errorEditingYaml", null, null, new String[0]);
                    LOGGER.error("Error editing policy YAML.", (Throwable)e);
                }
            } else if (yamlFiles.length > 1) {
                migrationReport.report("basicStructure.multipleYamlsFound", null, null, new String[0]);
            } else {
                migrationReport.report("basicStructure.noYamlFound", null, null, new String[0]);
            }
        }
    }
}

