/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.amqp;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.amqp.AbstractAmqpEndpoint;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AmqpOutboundEndpoint
extends AbstractAmqpEndpoint {
    public static final String XPATH_SELECTOR = "//*[(namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' or namespace-uri()='http://www.mulesoft.org/schema/mule/amqps') and local-name()='outbound-endpoint']";

    public String getDescription() {
        return "Update AMQP transport outbound endpoint.";
    }

    public AmqpOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{AMQP_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element tx = object.getChild("transaction", AMQP_NAMESPACE);
        while (tx != null) {
            object.setAttribute("transactionalAction", this.mapTransactionalAction(tx.getAttributeValue("action"), report, tx, object));
            object.removeChild("transaction", AMQP_NAMESPACE);
            tx = object.getChild("transaction", AMQP_NAMESPACE);
        }
        while (object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE) != null) {
            Element xaTx = object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
            object.setAttribute("transactionalAction", this.mapTransactionalAction(xaTx.getAttributeValue("action"), report, xaTx, object));
            object.removeChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
        }
        while (object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE) != null) {
            Element multiTx = object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
            object.setAttribute("transactionalAction", this.mapTransactionalAction(multiTx.getAttributeValue("action"), report, multiTx, object));
            object.removeChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
        }
        object.setNamespace(AMQP_NAMESPACE);
        if (object.getAttribute("exchange-pattern") == null || object.getAttributeValue("exchange-pattern").equals("one-way")) {
            object.setName("publish");
        } else {
            object.setName("publish-consume");
        }
        object.removeAttribute("exchange-pattern");
        Optional<Element> connector = AmqpOutboundEndpoint.resolveAmqpConnector(object, this.getApplicationModel());
        String configName = AmqpOutboundEndpoint.migrateAmqpConfig(object, report, connector, this.getApplicationModel());
        connector.ifPresent(m3c -> {
            Element reconnect;
            Element reconnectforever = m3c.getChild("reconnect-forever", XmlDslUtils.CORE_NAMESPACE);
            if (reconnectforever != null) {
                object.addContent((Content)new Element("reconnect-forever", XmlDslUtils.CORE_NAMESPACE).setAttribute("frequency", reconnectforever.getAttributeValue("frequency")));
            }
            if ((reconnect = m3c.getChild("reconnect", XmlDslUtils.CORE_NAMESPACE)) != null) {
                object.addContent((Content)new Element("reconnect", XmlDslUtils.CORE_NAMESPACE).setAttribute("frequency", reconnect.getAttributeValue("frequency")).setAttribute("count", reconnect.getAttributeValue("count")));
            }
            TransportsUtils.handleConnectorChildElements((Element)m3c, (Element)this.getApplicationModel().getNode("*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' and local-name()='config' and @name='" + configName + "']"), (Element)new Element("connection", XmlDslUtils.CORE_NAMESPACE), (MigrationReport)report);
        });
        object.setAttribute("config-ref", configName);
        if (XmlDslUtils.hasAttribute((Element)object, (String)"exchangeName") || XmlDslUtils.hasAttribute((Element)object, (String)"exchangeAutoDelete") || XmlDslUtils.hasAttribute((Element)object, (String)"exchangeDurable")) {
            this.resolveFallbackExchange(object, report);
        }
    }

    private void resolveFallbackExchange(Element object, MigrationReport report) {
        Element queueDefinition = new Element("fallback-exchange-definition", AMQP_NAMESPACE);
        Boolean autoDelete = Boolean.parseBoolean(object.getAttributeValue("exchangeAutoDelete"));
        Boolean queueDurable = Boolean.parseBoolean(object.getAttributeValue("exchangeDurable"));
        object.removeAttribute("exchangeAutoDelete");
        object.removeAttribute("exchangeDurable");
        String removalStrategy = this.resolveRemovalStrategy(autoDelete, queueDurable);
        if (removalStrategy != null) {
            queueDefinition.setAttribute("removalStrategy", removalStrategy);
        } else {
            report.report("amqp.exchangeRemovalStrategy", object, queueDefinition, new String[0]);
        }
        if (XmlDslUtils.hasAttribute((Element)object, (String)"exchangeType")) {
            queueDefinition.setAttribute("type", object.getAttributeValue("exchangeType"));
            object.removeAttribute("exchangeType");
        }
        object.addContent((Content)queueDefinition);
        if (XmlDslUtils.hasAttribute((Element)object, (String)"queueAutoDelete") || XmlDslUtils.hasAttribute((Element)object, (String)"queueDurable") || XmlDslUtils.hasAttribute((Element)object, (String)"queueExclusive")) {
            report.report("queueDefinitionInPublish", object, queueDefinition, new String[0]);
            object.removeAttribute("queueAutoDelete");
            object.removeAttribute("queueDurable");
            object.removeAttribute("queueExclusive");
        }
    }

    private String mapTransactionalAction(String action, MigrationReport report, Element tx, Element object) {
        if ("NONE".equals(action)) {
            return "NOT_SUPPORTED";
        }
        if ("ALWAYS_BEGIN".equals(action)) {
            report.report("jms.nestedTx", tx, object, new String[0]);
            return "ALWAYS_JOIN";
        }
        if ("BEGIN_OR_JOIN".equals(action)) {
            return "JOIN_IF_POSSIBLE";
        }
        return action;
    }
}

