/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.compression;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class CompressionInlinerStep
extends AbstractApplicationModelMigrationStep {
    public CompressionInlinerStep() {
        this.setAppliedTo(String.format("/*/*[local-name()='%s' or local-name()='%s' and @name and namespace-uri() = '%s']", "gzip-compress-transformer", "gzip-uncompress-transformer", "http://www.mulesoft.org/schema/mule/core"));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        String refName = element.getAttribute("name").getValue();
        List refs = this.getApplicationModel().getNodes(String.format("//mule:transformer[@ref = '%s']", refName));
        refs.forEach(ref -> {
            Element parent = ref.getParentElement();
            parent.addContent(this.getIndex(parent, (Element)ref), (Content)element.clone());
            ref.detach();
        });
        element.detach();
    }

    private int getIndex(Element parent, Element item) {
        int i = 0;
        for (Element child : parent.getChildren()) {
            if (child == item) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Could not locate transformer ref position");
    }
}

