/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class ForEachExpressions
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String XPATH_SELECTOR = "//mule:foreach";
    private static final String EXPRESSION_ATTRIBUTE = "collection";
    private ExpressionMigrator expressionMigrator;

    public ForEachExpressions() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public String getDescription() {
        return "Migrate For Each expressions.";
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Attribute expression = element.getAttribute(EXPRESSION_ATTRIBUTE);
        if (expression != null) {
            String migratedExpression = this.expressionMigrator.migrateExpression(expression.getValue(), true, element);
            migratedExpression = this.expressionMigrator.wrap(migratedExpression);
            expression.setValue(migratedExpression);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

