/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class ForEachScope
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"foreach");
    private static final String JSON_TRANSFORMER_NAME = "json-to-object-transformer";
    private static final String BYTE_ARRAY_TRANSFORMER_NAME = "byte-array-to-object-transformer";

    public String getDescription() {
        return "Update For Each Scope.";
    }

    public ForEachScope() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            Element transformerToRemove = this.getTransformerToRemove(element);
            if (transformerToRemove != null) {
                transformerToRemove.detach();
            }
        }
        catch (Exception ex) {
            throw new MigrationStepException("Failed to migrate references to Exception Strategies.");
        }
    }

    private Element getTransformerToRemove(Element element) {
        Integer elementIndex = element.getParentElement().getChildren().indexOf(element);
        if (elementIndex > 0) {
            Element previousElement = (Element)element.getParentElement().getChildren().get(elementIndex - 1);
            if (StringUtils.equals((CharSequence)previousElement.getName(), (CharSequence)JSON_TRANSFORMER_NAME) || StringUtils.equals((CharSequence)previousElement.getName(), (CharSequence)BYTE_ARRAY_TRANSFORMER_NAME)) {
                return previousElement;
            }
        } else {
            return null;
        }
        return null;
    }
}

