/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.library.mule.steps.os.AbstractOSMigrator;
import com.mulesoft.tools.migration.library.tools.mel.WatermarkSelectorMigrator;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Poll
extends AbstractOSMigrator {
    private static final String CRON_FREQ_SCHEDULER = "cron-scheduler";
    private static final String FIXED_FREQ_SCHEDULER = "fixed-frequency-scheduler";
    private static final String WATERMARK = "watermark";
    private static final String SCHEDULING_STRATEGY = "scheduling-strategy";
    private static final String POLL_NEW_NAME = "scheduler";
    private static final String PROCESSOR_CHAIN = "processor-chain";
    private static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"poll");
    private static final String SCHEDULERS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/schedulers";
    private static final String SCHEDULERS_NAMESPACE_PREFIX = "schedulers";
    private static final Namespace SCHEDULERS_NAMESPACE = Namespace.getNamespace((String)"schedulers", (String)"http://www.mulesoft.org/schema/mule/schedulers");
    private static final WatermarkSelectorMigrator watermarkSelectorMigrator = new WatermarkSelectorMigrator();

    public String getDescription() {
        return "Update Poll component.";
    }

    public Poll() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SCHEDULERS_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            ApplicationModelUtils.changeNodeName((String)"", (String)POLL_NEW_NAME).apply(element);
            XmlDslUtils.addMigrationAttributeToElement((Element)element, (Attribute)new Attribute("isMessageSource", "true"));
            List<Element> childElementsToMove = element.getChildren().stream().filter(s -> !StringUtils.equals((CharSequence)s.getName(), (CharSequence)FIXED_FREQ_SCHEDULER) && !StringUtils.equals((CharSequence)s.getName(), (CharSequence)CRON_FREQ_SCHEDULER) && !StringUtils.equals((CharSequence)s.getName(), (CharSequence)WATERMARK)).collect(Collectors.toList());
            this.movePollChildsToParent(childElementsToMove, element.getParentElement(), element.getParentElement().indexOf((Content)element) + 1);
            if (element.getChild(FIXED_FREQ_SCHEDULER, XmlDslUtils.CORE_NAMESPACE) == null && element.getChild(CRON_FREQ_SCHEDULER, SCHEDULERS_NAMESPACE) == null) {
                Element schedulingStrategy = new Element(SCHEDULING_STRATEGY, element.getNamespace());
                Element fixedFrequency = new Element("fixed-frequency", element.getNamespace());
                schedulingStrategy.addContent((Content)fixedFrequency);
                element.addContent((Content)schedulingStrategy);
                String newFrequency = XmlDslUtils.changeDefault((String)"1000", (String)"60000", (String)element.getAttributeValue("frequency"));
                if (newFrequency != null) {
                    fixedFrequency.setAttribute("frequency", newFrequency);
                }
                element.removeAttribute("frequency");
            } else {
                this.updateCronScheduler(element);
                this.updateFixedFrequencyScheduler(element);
            }
            if (element.getChild(WATERMARK, XmlDslUtils.CORE_NAMESPACE) != null) {
                Element watermark = element.getChild(WATERMARK, XmlDslUtils.CORE_NAMESPACE);
                Element osStore = new Element("store", NEW_OS_NAMESPACE);
                Element osRetrieve = new Element("retrieve", NEW_OS_NAMESPACE);
                XmlDslUtils.addMigrationAttributeToElement((Element)osStore, (Attribute)new Attribute("lastElement", "true"));
                osStore.setAttribute("failIfPresent", "false");
                osStore.setAttribute("failOnNullValue", "false");
                if (watermark.getAttribute("variable") != null) {
                    osStore.setAttribute("key", watermark.getAttributeValue("variable"));
                    osRetrieve.setAttribute("key", watermark.getAttributeValue("variable"));
                    osRetrieve.setAttribute("target", watermark.getAttributeValue("variable"));
                }
                if (watermark.getAttribute("default-expression") != null) {
                    String defaultExpression = this.getExpressionMigrator().migrateExpression(watermark.getAttributeValue("default-expression"), true, element);
                    this.setOSValue(osRetrieve, defaultExpression, "default-value");
                }
                if (watermark.getAttribute("update-expression") != null) {
                    String updateExpression = this.getExpressionMigrator().migrateExpression(watermark.getAttributeValue("update-expression"), true, element);
                    this.setOSValue(osStore, updateExpression, "value");
                } else if (watermark.getAttribute("selector-expression") != null || watermark.getAttribute("selector") != null) {
                    String selectorExpression = watermark.getAttributeValue("selector-expression");
                    String selector = watermark.getAttributeValue("selector");
                    if (selectorExpression == null) {
                        this.setOSValue(osStore, this.getExpressionFromSelector(selector), "value");
                    } else if (selector == null) {
                        selectorExpression = this.getExpressionMigrator().migrateExpression(selectorExpression, true, element);
                        this.setOSValue(osStore, selectorExpression, "value");
                    } else {
                        selectorExpression = watermarkSelectorMigrator.migrateSelector(selectorExpression, selector.toLowerCase(), element, report, this.getExpressionMigrator());
                        this.setOSValue(osStore, selectorExpression, "value");
                    }
                }
                if (watermark.getAttribute("object-store-ref") != null) {
                    osStore.setAttribute("objectStore", watermark.getAttributeValue("object-store-ref"));
                    osRetrieve.setAttribute("objectStore", watermark.getAttributeValue("object-store-ref"));
                }
                XmlDslUtils.addElementAfter((Element)osRetrieve, (Element)element);
                XmlDslUtils.addElementToBottom((Element)XmlDslUtils.getContainerElement((Element)element), (Element)osStore);
                watermark.detach();
                this.addOSModule();
            }
        }
        catch (Exception ex) {
            throw new MigrationStepException("Failed to migrate poll." + ex.getMessage() + ex.getStackTrace());
        }
    }

    private String getExpressionFromSelector(String selector) {
        String expression;
        switch (selector.toLowerCase()) {
            case "min": {
                expression = "#[min(payload)]";
                break;
            }
            case "max": {
                expression = "#[max(payload)]";
                break;
            }
            case "first": {
                expression = "#[payload[0]]";
                break;
            }
            case "last": {
                expression = "#[payload[-1]]";
                break;
            }
            default: {
                throw new IllegalArgumentException("Selector " + selector + " doesn't match with any valid value.");
            }
        }
        return expression;
    }

    private void updateFixedFrequencyScheduler(Element element) {
        if (element.getChild(FIXED_FREQ_SCHEDULER, XmlDslUtils.CORE_NAMESPACE) != null) {
            Element fixedScheduler = element.getChild(FIXED_FREQ_SCHEDULER, XmlDslUtils.CORE_NAMESPACE);
            this.moveSchedulerToSchedulingStrategy(fixedScheduler, "fixed-frequency");
            this.moveAttributeToChildNode(fixedScheduler.getAttribute("frequency"), element, "fixed-frequency");
            this.moveAttributeToChildNode(fixedScheduler.getAttribute("startDelay"), element, "fixed-frequency");
            this.moveAttributeToChildNode(fixedScheduler.getAttribute("timeUnit"), element, "fixed-frequency");
        }
    }

    private void updateCronScheduler(Element element) {
        if (element.getChild(CRON_FREQ_SCHEDULER, SCHEDULERS_NAMESPACE) != null) {
            Element cronScheduler = element.getChild(CRON_FREQ_SCHEDULER, SCHEDULERS_NAMESPACE);
            this.moveSchedulerToSchedulingStrategy(cronScheduler, "cron");
            this.moveAttributeToChildNode(cronScheduler.getAttribute("expression"), element, "cron");
            this.moveAttributeToChildNode(cronScheduler.getAttribute("timeZone"), element, "cron");
        }
    }

    private void moveSchedulerToSchedulingStrategy(Element element, String newSchedulerChildNode) {
        ApplicationModelUtils.addChildNode((String)"", (String)SCHEDULING_STRATEGY).apply(element.getParentElement());
        ApplicationModelUtils.addChildNode((String)"", (String)newSchedulerChildNode).apply(element.getParentElement().getChild(SCHEDULING_STRATEGY, XmlDslUtils.CORE_NAMESPACE));
        element.getParent().removeContent((Content)element);
    }

    private void moveAttributeToChildNode(Attribute attribute, Element parent, String childName) {
        if (attribute != null) {
            attribute.getParent().removeAttribute(attribute);
            Element scheduler = parent.getChild(SCHEDULING_STRATEGY, XmlDslUtils.CORE_NAMESPACE);
            Element childScheduler = scheduler.getChild(childName, XmlDslUtils.CORE_NAMESPACE);
            childScheduler.setAttribute(attribute);
        }
    }

    private void movePollChildsToParent(List<Element> elements, Element parent, Integer position) {
        ArrayList childs = new ArrayList();
        elements.forEach(n -> {
            if (StringUtils.equals((CharSequence)n.getName(), (CharSequence)PROCESSOR_CHAIN)) {
                this.movePollChildsToParent(n.getChildren(), parent, position);
                n.detach();
            } else {
                childs.add(n);
            }
        });
        if (childs.size() > 0) {
            childs.forEach(s -> s.getParent().removeContent((Content)s));
            parent.addContent(position.intValue(), childs);
        }
    }
}

