/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.nio.file.Path;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class SpringImport
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.springframework.org/schema/beans' and local-name()='import']";

    public String getDescription() {
        return "Migrate Spring Imports for mule config files.";
    }

    public SpringImport() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Attribute resource = element.getAttribute("resource");
        Element parent = element.getParentElement();
        if (resource != null && XmlDslUtils.isMuleConfigFile((String)resource.getValue(), (Path)this.getApplicationModel().getProjectBasePath())) {
            element.setNamespace(XmlDslUtils.CORE_NAMESPACE);
            resource.setName("file");
            element.detach();
            XmlDslUtils.addTopLevelElement((Element)element, (Document)parent.getDocument());
        }
        if (parent.getChildren().isEmpty()) {
            parent.detach();
        }
    }
}

