/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationMigration;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import org.jdom2.Content;
import org.jdom2.Element;

public class UntilSuccessful
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//mule:*[local-name()='until-successful']";
    private ExpressionMigrator expressionMigrator;

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public String getDescription() {
        return "Migrate Until Successful.";
    }

    public UntilSuccessful() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ArrayList childs = new ArrayList(element.getChildren());
        childs.forEach(c -> {
            if (c.getName().equals("processor-chain")) {
                ArrayList chainNodes = new ArrayList(c.getChildren());
                chainNodes.forEach(n -> n.detach());
                element.addContent(element.indexOf((Content)c), chainNodes);
                c.detach();
            } else if (c.getName().equals("threading-profile")) {
                report.report("untilSuccessful.threading", c, element, new String[0]);
                c.detach();
            }
        });
        XmlDslUtils.removeAttribute((Element)element, (String)"objectStore-ref");
        XmlDslUtils.removeAttribute((Element)element, (String)"synchronous");
        if (element.getAttribute("ackExpression") != null) {
            Element setPayload = new Element("set-payload", element.getNamespace());
            setPayload.setAttribute("value", this.getExpressionMigrator().migrateExpression(element.getAttributeValue("ackExpression"), true, element));
            XmlDslUtils.addElementAfter((Element)setPayload, (Element)element);
            XmlDslUtils.removeAttribute((Element)element, (String)"ackExpression");
        }
        if (element.getAttribute("secondsBetweenRetries") != null) {
            Integer retries = Integer.valueOf(element.getAttributeValue("secondsBetweenRetries")) * 1000;
            element.setAttribute("millisBetweenRetries", retries.toString());
            XmlDslUtils.removeAttribute((Element)element, (String)"secondsBetweenRetries");
        }
        if (element.getAttribute("deadLetterQueue-ref") != null) {
            Element flow = XmlDslUtils.getContainerElement((Element)element);
            Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement((Element)flow);
            if (errorHandler == null) {
                errorHandler = new Element("error-handler", element.getNamespace());
                flow.addContent(flow.getContent().size() - 1, (Content)errorHandler);
            }
            Element retryExhaustedHandler = new Element("on-error-propagate", element.getNamespace());
            retryExhaustedHandler.setAttribute("type", "RETRY_EXHAUSTED");
            Element outboundEndPoint = new Element("outbound-endpoint", element.getNamespace());
            outboundEndPoint.setAttribute("ref", element.getAttributeValue("deadLetterQueue-ref"));
            retryExhaustedHandler.addContent((Content)outboundEndPoint);
            errorHandler.addContent((Content)retryExhaustedHandler);
            XmlDslUtils.removeAttribute((Element)element, (String)"deadLetterQueue-ref");
        }
        if (element.getAttribute("failureExpression") != null) {
            ValidationMigration.addValidationNamespace(element.getDocument());
            Element validation = new Element("is-false", ValidationMigration.VALIDATION_NAMESPACE);
            String expression = element.getAttributeValue("failureExpression");
            validation.setAttribute("expression", this.getExpressionMigrator().migrateExpression(expression, true, element));
            element.addContent((Content)validation);
            XmlDslUtils.removeAttribute((Element)element, (String)"failureExpression");
        }
    }
}

