/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Collection;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class MessageFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"message-filter");

    @Override
    public String getDescription() {
        return "Update message-filters.";
    }

    public MessageFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        if (element.getParentElement().isRootElement()) {
            return;
        }
        if (element.getAttribute("onUnaccepted") != null) {
            Element wrappingTry = new Element("try", XmlDslUtils.CORE_NAMESPACE);
            if (element.getAttribute("throwOnUnaccepted") != null && element.getAttributeValue("throwOnUnaccepted").equals("false")) {
                report.report("filters.validationsRaiseError", element, wrappingTry, new String[0]);
            }
            element.removeAttribute("throwOnUnaccepted");
            XmlDslUtils.addElementAfter((Element)wrappingTry, (Element)element);
            wrappingTry.addContent((Collection)element.cloneContent());
            wrappingTry.addContent((Content)new Element("error-handler", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("on-error-propagate", XmlDslUtils.CORE_NAMESPACE).setAttribute("type", "MULE:VALIDATION").setAttribute("logException", "false").addContent((Content)new Element("flow-ref", XmlDslUtils.CORE_NAMESPACE).setAttribute("name", element.getAttributeValue("onUnaccepted")))));
        } else {
            List clonedContent = element.cloneContent();
            if (element.getAttribute("throwOnUnaccepted") == null || element.getAttributeValue("throwOnUnaccepted").equals("false")) {
                report.report("filters.validationsRaiseError", element, (Element)clonedContent.stream().filter(c -> c instanceof Element).findFirst().get(), new String[0]);
            }
            element.removeAttribute("throwOnUnaccepted");
            XmlDslUtils.addElementsAfter((Collection)clonedContent, (Element)element);
        }
        element.detach();
    }
}

