/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class NotFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"not-filter");

    @Override
    public String getDescription() {
        return "Update not-filter to validations.";
    }

    public NotFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        if (element.getChildren().isEmpty()) {
            element.detach();
        } else {
            this.addValidationsModule(element.getDocument());
            List<Content> negated = element.cloneContent().stream().map(e -> e instanceof Element ? this.negateValidator((Element)e, report, element) : e).collect(Collectors.toList());
            XmlDslUtils.addElementsAfter(negated, (Element)element);
            negated.forEach(e -> {
                if (e instanceof Element) {
                    this.handleFilter((Element)e);
                }
            });
            element.detach();
        }
    }

    public Element negateValidator(Element validator, MigrationReport report, Element original) {
        if ("is-true".equals(validator.getName())) {
            validator.setName("is-false");
        } else if ("is-false".equals(validator.getName())) {
            validator.setName("is-true");
        } else if ("matches-regex".equals(validator.getName())) {
            Attribute regexAttr = validator.getAttribute("regex");
            if (regexAttr.getValue().startsWith("(?!") && regexAttr.getValue().endsWith(")")) {
                regexAttr.setValue(StringUtils.substring((String)regexAttr.getValue(), (int)3, (int)-1));
            } else {
                regexAttr.setValue("(?!" + regexAttr.getValue() + ")");
            }
        } else if ("any".equals(validator.getName())) {
            validator.setName("all");
            validator.getChildren().forEach(c -> this.negateValidator((Element)c, report, original));
        } else if ("all".equals(validator.getName())) {
            validator.setName("any");
            validator.getChildren().forEach(c -> this.negateValidator((Element)c, report, original));
        } else {
            report.report("filters.negated", original, validator, new String[0]);
        }
        return validator;
    }
}

