/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ee;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CacheScope
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/ee/core' and local-name()='cache']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Migrate EE Cache scope";
    }

    public CacheScope() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{XmlDslUtils.CORE_EE_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("filterExpression"), (ExpressionMigrator)this.expressionMigrator);
        if (element.getAttribute("filter-ref") != null) {
            element.removeAttribute("filter-ref");
            element.setAttribute("filterExpression", "#[false]");
            report.report("cache.filterExpression", element, element, new String[0]);
        }
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }
}

