/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ee;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class EETransform
extends AbstractApplicationModelMigrationStep {
    private static final String DW_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/ee/dw";
    private static final Namespace DW_NAMESPACE = Namespace.getNamespace((String)"dw", (String)"http://www.mulesoft.org/schema/mule/ee/dw");
    private static final String DW_NAMESPACE_SCHEMA = "http://www.mulesoft.org/schema/mule/ee/dw/current/dw.xsd";
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/ee/dw' and local-name()='transform-message']";

    public String getDescription() {
        return "Migrate EE Transform DW 1.0 Script to DW 2.0";
    }

    public EETransform() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{DW_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Namespace eeNamespace = XmlDslUtils.CORE_EE_NAMESPACE;
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)eeNamespace, (String)"http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd", (Document)element.getDocument());
        this.getApplicationModel().removeNameSpace(DW_NAMESPACE, DW_NAMESPACE_SCHEMA, element.getDocument());
        element.setNamespace(eeNamespace);
        element.setName("transform");
        Element messageNode = new Element("message", element.getNamespace());
        Element variablesNode = new Element("variables", element.getNamespace());
        ArrayList transformerNodes = new ArrayList(element.getChildren());
        transformerNodes.forEach(n -> {
            if ("input-payload".equals(n.getName())) {
                XmlDslUtils.addElementBefore((Element)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[payload]").setAttribute("mimeType", n.getAttributeValue("mimeType") + this.readerPropsToMimeTypeParams((Element)n)), (Element)element);
                n.detach();
            } else if ("input-variable".equals(n.getName())) {
                XmlDslUtils.addElementBefore((Element)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", n.getAttributeValue("variableName")).setAttribute("value", "#[vars." + n.getAttributeValue("variableName") + "]").setAttribute("mimeType", n.getAttributeValue("mimeType") + this.readerPropsToMimeTypeParams((Element)n)), (Element)element);
                n.detach();
            } else if ("input-session-variable".equals(n.getName())) {
                XmlDslUtils.addCompatibilityNamespace((Document)element.getDocument());
                Element sessionVar = new Element("set-session-variable", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("variableName", n.getAttributeValue("variableName")).setAttribute("value", "#[vars." + n.getAttributeValue("variableName") + "]").setAttribute("mimeType", n.getAttributeValue("mimeType") + this.readerPropsToMimeTypeParams((Element)n));
                XmlDslUtils.addElementBefore((Element)sessionVar, (Element)element);
                report.report("transform.sessionVars", sessionVar, sessionVar, new String[0]);
                n.detach();
            } else if ("input-inbound-property".equals(n.getName()) || "input-outbound-property".equals(n.getName())) {
                Element setProperty = new Element("set-property", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("propertyName", n.getAttributeValue("propertyName")).setAttribute("value", "#[vars." + n.getAttributeValue("propertyName") + "]").setAttribute("mimeType", n.getAttributeValue("mimeType") + this.readerPropsToMimeTypeParams((Element)n));
                report.report("transform.outboundProperties", setProperty, setProperty, new String[0]);
                n.detach();
            } else {
                n.setNamespace(element.getNamespace());
                this.migrateDWScript((Element)n, report);
                if ("set-payload".equals(n.getName())) {
                    n.detach();
                    messageNode.addContent((Content)n);
                } else {
                    this.moveToVariablesSection((Element)n, variablesNode, report);
                }
            }
        });
        if (messageNode.getChildren().size() > 0) {
            element.addContent((Content)messageNode);
        }
        if (variablesNode.getChildren().size() > 0) {
            element.addContent((Content)variablesNode);
        }
    }

    private String readerPropsToMimeTypeParams(Element n) {
        StringBuilder readerMimeTypeParams = new StringBuilder();
        for (Element readerProp : n.getChildren("reader-property", DW_NAMESPACE)) {
            readerMimeTypeParams.append("; " + readerProp.getAttributeValue("name") + "=\"" + readerProp.getAttributeValue("value") + "\"");
        }
        return readerMimeTypeParams.toString();
    }

    private void moveToVariablesSection(Element element, Element variablesSection, MigrationReport report) {
        if ("set-session-variable".equals(element.getName())) {
            this.addSessionVariable(element, report);
        } else if ("set-property".equals(element.getName())) {
            Attribute propName = element.getAttribute("propertyName");
            propName.setName("variableName");
            this.addOutboundProperty(element, report);
        }
        element.setName("set-variable");
        element.detach();
        variablesSection.addContent((Content)element);
    }

    private void addSessionVariable(Element element, MigrationReport report) {
        XmlDslUtils.addCompatibilityNamespace((Document)element.getDocument());
        Element sessionVar = new Element("set-session-variable", TransportsUtils.COMPATIBILITY_NAMESPACE);
        Attribute varName = element.getAttribute("variableName");
        sessionVar.setAttribute(new Attribute(varName.getName(), varName.getValue()));
        sessionVar.setAttribute(new Attribute("value", "#[vars." + varName.getValue() + "]"));
        XmlDslUtils.addElementAfter((Element)sessionVar, (Element)element.getParentElement());
        report.report("transform.sessionVars", sessionVar, sessionVar, new String[0]);
    }

    private void addOutboundProperty(Element element, MigrationReport report) {
        Attribute propName = element.getAttribute("variableName");
        Element setProperty = XmlDslUtils.addOutboundPropertySetter((String)propName.getValue(), (Element)element, (ApplicationModel)this.getApplicationModel(), (Element)element.getParentElement());
        report.report("transform.outboundProperties", setProperty, setProperty, new String[0]);
    }

    private void migrateDWScript(Element element, MigrationReport report) {
        Attribute resourceAttr;
        String resourceValue;
        if (!StringUtils.isEmpty((CharSequence)element.getText())) {
            try {
                String migratedScript = DataWeaveHelper.migrateDWToV2(element.getText());
                element.removeContent();
                XmlDslUtils.setText((Element)element, (String)migratedScript);
            }
            catch (Exception ex) {
                report.report("dataWeave.migrationErrorScript", element, element, new String[]{element.getText(), ex.getMessage()});
            }
        } else if (element.getAttribute("resource") != null && (resourceValue = (resourceAttr = element.getAttribute("resource")).getValue()).startsWith("classpath:")) {
            resourceValue = resourceValue.replace("classpath:", "");
            resourceAttr.setValue(resourceValue);
        }
    }
}

