/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ee;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class MigrateDWScriptFiles
implements ProjectStructureContribution {
    public String getDescription() {
        return "Migrate .dwl files to DW v2.0.";
    }

    public void execute(Path basePath, MigrationReport report) throws RuntimeException {
        String[] extensions = new String[]{"dwl"};
        List dwFiles = (List)FileUtils.listFiles((File)basePath.toFile(), (String[])extensions, (boolean)true);
        dwFiles.forEach(f -> {
            try {
                this.migrateFile((File)f);
            }
            catch (Exception ex) {
                report.report("dataWeave.migrationErrorFile", null, null, new String[]{f.getPath(), ex.getMessage()});
            }
        });
    }

    private void migrateFile(File file) {
        try {
            String dwScript = new String(Files.readAllBytes(file.toPath()));
            dwScript = DataWeaveHelper.migrateDWToV2(dwScript);
            Files.write(file.toPath(), dwScript.getBytes(), new OpenOption[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

