/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.email;

import com.mulesoft.tools.migration.library.mule.steps.email.AbstractEmailSourceMigrator;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import java.util.OptionalInt;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class ImapInboundEndpoint
extends AbstractEmailSourceMigrator
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/imap' and local-name()='inbound-endpoint'][1]";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update IMap transport inbound endpoint.";
    }

    public ImapInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("listener-imap");
        object.setNamespace(EMAIL_NAMESPACE);
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        this.addAttributesToInboundProperties(object, report);
        Optional<Element> imapConnector = this.resolveConnector(object, this.getApplicationModel());
        this.getApplicationModel().addNameSpace(EMAIL_NAMESPACE.getPrefix(), EMAIL_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/email/current/mule-email.xsd");
        TransportsUtils.migrateSchedulingStrategy((Element)object, (OptionalInt)OptionalInt.empty());
        Element fixedFrequency = object.getChild("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE).getChild("fixed-frequency", XmlDslUtils.CORE_NAMESPACE);
        imapConnector.ifPresent(c -> {
            TransportsUtils.handleServiceOverrides((Element)c, (MigrationReport)report);
            XmlDslUtils.migrateReconnection((Element)c, (Element)object, (MigrationReport)report);
            if (c.getAttribute("moveToFolder") != null) {
                report.report("email.moveToFolder", c, object, new String[0]);
            }
            if (c.getAttribute("mailboxFolder") != null) {
                object.setAttribute("folder", c.getAttributeValue("mailboxFolder"));
            }
            if (c.getAttribute("backupEnabled") != null || c.getAttribute("backupFolder") != null) {
                report.report("email.imapBackup", c, object, new String[0]);
            }
            if (c.getAttribute("deleteReadMessages") != null) {
                object.setAttribute("deleteAfterRetrieve", c.getAttributeValue("deleteReadMessages"));
            }
            if (c.getAttribute("defaultProcessMessageAction") != null) {
                object.removeAttribute("defaultProcessMessageAction");
                report.report("email.imapDefaultProcessMessageAction", c, object, new String[0]);
            }
            if (c.getAttribute("checkFrequency") != null) {
                fixedFrequency.setAttribute("frequency", c.getAttributeValue("checkFrequency"));
            }
        });
        Element m4Config = this.migrateImapConfig(object, report, imapConnector);
        Element connection = this.getConnection(m4Config);
        if (imapConnector.isPresent() && "gmail-connector".equals(imapConnector.get().getName())) {
            connection.setName("imaps-connection");
            connection.addContent((Content)new Element("context", TLS_NAMESPACE).addContent((Content)new Element("trust-store", TLS_NAMESPACE).setAttribute("insecure", "true")));
            connection.setAttribute("host", "imap.gmail.com");
            connection.setAttribute("port", "993");
            object.removeAttribute("host");
            object.removeAttribute("port");
            this.getApplicationModel().addNameSpace(TLS_NAMESPACE.getPrefix(), TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
            report.report("email.gmail", imapConnector.get(), connection, new String[0]);
        } else {
            TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
                connection.setAttribute("host", address.getHost());
                connection.setAttribute("port", address.getPort());
                if (address.getCredentials() != null) {
                    String[] credsSplit = address.getCredentials().split(":");
                    connection.setAttribute("user", credsSplit[0]);
                    connection.setAttribute("password", credsSplit[1]);
                }
            });
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
        }
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.removeAttribute("name");
            object.setAttribute("config-ref", m4Config.getAttributeValue("name"));
        }
        if (object.getAttribute("responseTimeout") != null) {
            connection.setAttribute("readTimeout", object.getAttributeValue("responseTimeout"));
            connection.setAttribute("writeTimeout", object.getAttributeValue("responseTimeout"));
            connection.setAttribute("timeoutUnit", "MILLISECONDS");
            object.removeAttribute("responseTimeout");
        }
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/imap' and (local-name()='connector' or local-name()='gmail-connector') and @name = '" + connectorName + "']");
    }

    protected Element getConnection(Element m4Config) {
        return m4Config.getChild("imap-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/imap' and (local-name()='connector' or local-name()='gmail-connector')]");
    }

    public Element migrateImapConfig(Element object, MigrationReport report, Optional<Element> connector) {
        String configName = connector.map(conn -> conn.getAttributeValue("name")).orElse((object.getAttribute("name") != null ? object.getAttributeValue("name") : (object.getAttribute("ref") != null ? object.getAttributeValue("ref") : "")).replaceAll("\\\\", "_") + "ImapConfig");
        Optional config = this.getApplicationModel().getNodeOptional("*/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'imap-config' and @name='" + configName + "']");
        return config.orElseGet(() -> {
            Element imapCfg = new Element("imap-config", EMAIL_NAMESPACE);
            imapCfg.setAttribute("name", configName);
            Element connection = this.createConnection();
            imapCfg.addContent((Content)connection);
            XmlDslUtils.addTopLevelElement((Element)imapCfg, (Document)connector.map(c -> c.getDocument()).orElse(object.getDocument()));
            return imapCfg;
        });
    }

    protected Element createConnection() {
        return new Element("imap-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected String getInboundAttributesClass() {
        return "org.mule.extension.email.api.attributes.IMAPEmailAttributes";
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

