/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ftp;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.file.FileConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FtpConfig
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String FTP_NAMESPACE_PREFIX = "ftp";
    private static final String FTP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/ftp";
    public static final Namespace FTP_NAMESPACE = Namespace.getNamespace((String)"ftp", (String)"http://www.mulesoft.org/schema/mule/ftp");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'connector']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update FTP connector config.";
    }

    public FtpConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{FTP_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        TransportsUtils.handleServiceOverrides((Element)object, (MigrationReport)report);
        this.handleInputImplicitConnectorRef(object, report);
        this.handleOutputImplicitConnectorRef(object, report);
        object.setName("config");
        object.setNamespace(FTP_NAMESPACE);
        Element connection = new Element("connection", FTP_NAMESPACE);
        object.addContent((Content)connection);
        if (object.getAttribute("streaming") != null && !"true".equals(object.getAttributeValue("streaming"))) {
            report.report("ftp.streaming", object, object, new String[0]);
        }
        object.removeAttribute("streaming");
        if (object.getAttribute("connectionFactoryClass") != null && !"true".equals(object.getAttributeValue("connectionFactoryClass"))) {
            report.report("ftp.connectionFactoryClass", object, object, new String[0]);
        }
        object.removeAttribute("connectionFactoryClass");
        XmlDslUtils.migrateReconnection((Element)connection, (Element)object, (MigrationReport)report);
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"passive");
        if (object.getAttribute("binary") != null) {
            connection.setAttribute("transferMode", "true".equals(object.getAttributeValue("binary")) ? "BINARY" : "ASCII");
            object.removeAttribute("binary");
        }
        if (object.getAttribute("connectionTimeout") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"connectionTimeout", (String)"connectionTimeout");
            connection.setAttribute("connectionTimeoutUnit", "MILLISECONDS");
        }
        FileConfig.handleChildElements(object, connection, report);
        this.handleInputSpecificAttributes(object, report);
        this.handleOutputSpecificAttributes(object, report);
    }

    private void handleInputImplicitConnectorRef(Element object, MigrationReport report) {
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("/*/mule:flow/ftp:inbound-endpoint[not(@connector-ref)]"));
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//mule:inbound-endpoint[not(@connector-ref) and starts-with(@address, 'ftp://')]"));
    }

    private void handleOutputImplicitConnectorRef(Element object, MigrationReport report) {
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//ftp:outbound-endpoint[not(@connector-ref)]"));
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//mule:outbound-endpoint[not(@connector-ref) and starts-with(@address, 'ftp://')]"));
    }

    private void makeImplicitConnectorRefsExplicit(Element object, MigrationReport report, List<Element> implicitConnectorRefs) {
        List availableConfigs = this.getApplicationModel().getNodes("/*/ftp:config");
        if (implicitConnectorRefs.size() > 0 && availableConfigs.size() > 1) {
            for (Element implicitConnectorRef : implicitConnectorRefs) {
                report.report("transports.manyConnectors", implicitConnectorRef, implicitConnectorRef, new String[]{FTP_NAMESPACE_PREFIX, availableConfigs.stream().map(e -> e.getAttributeValue("name")).collect(Collectors.joining(", "))});
            }
        } else {
            for (Element implicitConnectorRef : implicitConnectorRefs) {
                implicitConnectorRef.setAttribute("connector-ref", object.getAttributeValue("name"));
            }
        }
    }

    private void handleInputSpecificAttributes(Element object, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//ftp:inbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:inbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToInboundEnpoint(object, (Element)e));
        object.removeAttribute("pollingFrequency");
    }

    private void handleOutputSpecificAttributes(Element object, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//ftp:outbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:outbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToOutboundEndpoint(object, (Element)e));
        object.removeAttribute("outputPattern");
    }

    private void passConnectorConfigToInboundEnpoint(Element object, Element listener) {
        Element schedulingStr = new Element("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE);
        listener.addContent((Content)schedulingStr);
        Element fixedFrequency = new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE);
        fixedFrequency.setAttribute("frequency", object.getAttributeValue("pollingFrequency", "1000"));
        schedulingStr.addContent((Content)fixedFrequency);
    }

    private void passConnectorConfigToOutboundEndpoint(Element object, Element write) {
        if (object.getAttribute("outputPattern") != null) {
            write.setAttribute("outputPatternConfig", object.getAttributeValue("outputPattern"));
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

