/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Arrays;
import org.jdom2.Content;
import org.jdom2.Element;

public class HttpConnectorListenerConfig
extends AbstractHttpConnectorMigrationStep {
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='listener-config']";

    public String getDescription() {
        return "Update HTTP Connector listener config.";
    }

    public HttpConnectorListenerConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Arrays.asList(HTTP_NAMESPACE));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(HTTP_NAMESPACE);
        if ("listener-config".equals(object.getName()) && object.getChild("listener-connection", HTTP_NAMESPACE) == null) {
            Element listenerConnection = new Element("listener-connection", HTTP_NAMESPACE);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"protocol");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"host");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"port");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"usePersistentConnections");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"connectionIdleTimeout");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"tlsContext-ref", (String)"tlsContext");
            if (object.getAttribute("parseRequest") != null && !"false".equals(object.getAttributeValue("parseRequest"))) {
                report.report("http.parseRequest", object, object, new String[0]);
            }
            object.addContent((Content)listenerConnection);
        }
        object.getChildren().forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.execute((Element)c, report);
            } else if ("http://www.mulesoft.org/schema/mule/tls".equals(c.getNamespaceURI()) && "context".equals(c.getName())) {
                Element listenerConnection = c.getParentElement().getChild("listener-connection", HTTP_NAMESPACE);
                c.getParentElement().removeContent((Content)c);
                listenerConnection.addContent((Content)c);
            }
        });
        if ("worker-threading-profile".equals(object.getName())) {
            report.report("flow.threading", object, object.getParentElement(), new String[0]);
            object.getParentElement().removeContent((Content)object);
        }
    }
}

