/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpConnectorListener;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HttpInboundEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='inbound-endpoint'][1]";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update HTTP transport inbound endpoint.";
    }

    public HttpInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element errorResponse;
        Element response;
        HttpConnectorListener.httpListenerLib(this.getApplicationModel());
        object.setNamespace(AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
        object.setName("listener");
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        String flowName = XmlDslUtils.getContainerElement((Element)object).getAttributeValue("name");
        String configName = (object.getAttribute("name") != null ? object.getAttributeValue("name") : (object.getAttribute("ref") != null ? object.getAttributeValue("ref") : flowName)).replaceAll("\\\\", "_") + "ListenerConfig";
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
            HttpInboundEndpoint.extractListenerConfig(this.getApplicationModel(), object, () -> this.getConnector(object.getAttributeValue("connector-ref")), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE, configName, address.getHost(), address.getPort());
            if (address.getPath() != null) {
                if (address.getPath().endsWith("*")) {
                    object.setAttribute("path", address.getPath());
                } else {
                    object.setAttribute("path", address.getPath().endsWith("/") ? address.getPath() + "*" : address.getPath() + "/*");
                }
            }
        });
        if (object.getAttribute("host") != null && object.getAttribute("port") != null) {
            HttpInboundEndpoint.extractListenerConfig(this.getApplicationModel(), object, () -> this.getConnector(object.getAttributeValue("connector-ref")), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE, configName, object.getAttributeValue("host"), object.getAttributeValue("port"));
            object.removeAttribute("host");
            object.removeAttribute("port");
        }
        if (object.getAttribute("connector-ref") != null) {
            Element connector2 = this.getConnector(object.getAttributeValue("connector-ref"));
            this.handleConnector(connector2, object, report);
            object.removeAttribute("connector-ref");
        } else {
            this.getDefaultConnector().ifPresent(connector -> this.handleConnector((Element)connector, object, report));
        }
        if (object.getAttribute("method") != null) {
            object.getAttribute("method").setName("allowedMethods");
        }
        if (object.getAttribute("path") == null) {
            object.setAttribute("path", "/*");
        } else {
            String path = object.getAttributeValue("path");
            if (!path.endsWith("*")) {
                object.setAttribute("path", path.endsWith("/") ? path + "*" : path + "/*");
            }
        }
        this.getApplicationModel().getNodes("/*/mule:flow[@name='" + flowName + "']/*[namespace-uri()='" + "http://www.mulesoft.org/schema/mule/http" + "' and local-name()='response-builder']").forEach(rb -> {
            HttpConnectorListener.handleReferencedResponseBuilder(rb, this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            Element response = this.getResponse(object, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            this.handleResponseBuilder(object, response, (Element)rb, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            XmlDslUtils.copyAttributeIfPresent((Element)rb, (Element)response, (String)"statusCode");
            XmlDslUtils.copyAttributeIfPresent((Element)rb, (Element)response, (String)"reasonPhrase");
            if (response.getAttribute("statusCode") == null) {
                response.setAttribute("statusCode", "#[migration::HttpListener::httpListenerResponseSuccessStatusCode(vars)]");
                report.report("http.statusCode", response, response, new String[0]);
            }
            response.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE));
        });
        this.getApplicationModel().getNodes("/*/mule:flow[@name='" + flowName + "']/*[namespace-uri()='" + "http://www.mulesoft.org/schema/mule/http" + "' and local-name()='error-response-builder']").forEach(rb -> {
            HttpConnectorListener.handleReferencedResponseBuilder(rb, this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            Element errorResponse = this.getErrorResponse(object, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            this.handleResponseBuilder(object, errorResponse, (Element)rb, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            XmlDslUtils.copyAttributeIfPresent((Element)rb, (Element)errorResponse, (String)"statusCode");
            XmlDslUtils.copyAttributeIfPresent((Element)rb, (Element)errorResponse, (String)"reasonPhrase");
            if (errorResponse.getAttribute("statusCode") == null) {
                errorResponse.setAttribute("statusCode", "#[vars.statusCode default migration::HttpListener::httpListenerResponseErrorStatusCode(vars)]");
                report.report("http.statusCode", errorResponse, errorResponse, new String[0]);
            }
            errorResponse.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE));
        });
        if (object.getAttribute("contentType") != null) {
            response = this.getResponse(object, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            response.addContent((Content)new Element("header", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("headerName", "Content-Type").setAttribute("value", object.getAttributeValue("contentType")));
            response.setAttribute("statusCode", "#[migration::HttpListener::httpListenerResponseSuccessStatusCode(vars)]");
            report.report("http.statusCode", response, response, new String[0]);
            response.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE));
            object.removeAttribute("contentType");
        }
        if ((response = object.getChild("response", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE)) == null) {
            response = this.getResponse(object, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            response.setAttribute("statusCode", "#[migration::HttpListener::httpListenerResponseSuccessStatusCode(vars)]");
            report.report("http.statusCode", response, response, new String[0]);
            response.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE));
        }
        if ((errorResponse = object.getChild("error-response", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE)) == null) {
            errorResponse = this.getErrorResponse(object, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            errorResponse.setAttribute("statusCode", "#[vars.statusCode default migration::HttpListener::httpListenerResponseErrorStatusCode(vars)]");
            report.report("http.statusCode", errorResponse, errorResponse, new String[]{"Avoid using an outbound property to determine the status code."});
            errorResponse.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE));
        }
        TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        HttpConnectorListener.addAttributesToInboundProperties(object, this.getApplicationModel(), report);
        Element checkPayload = new Element("choice", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("when", XmlDslUtils.CORE_NAMESPACE).setAttribute("expression", "#[message.attributes.headers['Transfer-Encoding'] == null and (message.attributes.headers['Content-Length'] as Number default 0) == 0]").addContent((Content)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[message.attributes.requestUri]")));
        XmlDslUtils.addElementAfter((Element)checkPayload, (Element)object);
        report.report("http.checkPayload", checkPayload, checkPayload, new String[0]);
        if (object.getAttribute("name") != null) {
            object.removeAttribute("name");
        }
        if (object.getAttribute("ref") != null) {
            object.removeAttribute("ref");
        }
    }

    public static Element connectionHeaders(ApplicationModel appModel, Namespace httpNamespace) {
        try {
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath()), "HttpInboundConnectionAndKeepAliveHeaders.dwl", "/**" + System.lineSeparator() + " * Emulates the Connection and Keep-Alive inbound headers logic of the Mule 3.x HTTP Connector." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpInboundConnectionAndKeepAliveHeaders(version, headers: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties default {} filterObject" + System.lineSeparator() + "        ((value,key) -> not ((key as String) matches matcher_regex))" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return XmlDslUtils.setText((Element)new Element("headers", httpNamespace), (String)"#[migration::HttpListener::httpListenerResponseHeaders(vars)]");
    }

    public static void extractListenerConfig(ApplicationModel appModel, Element object, Supplier<Element> connectorLookup, Namespace httpNamespace, String configName, String host, String port) {
        Optional existingListener = appModel.getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='listener-config']/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='listener-connection' and @host = '" + host + "' and @port = '" + port + "']");
        if (existingListener.isPresent()) {
            object.setAttribute("config-ref", ((Element)existingListener.get()).getParentElement().getAttributeValue("name"));
        } else {
            Element connector;
            Element listenerConfig = new Element("listener-config", httpNamespace).setAttribute("name", configName);
            Element listenerConnection = new Element("listener-connection", httpNamespace);
            listenerConnection.setAttribute("host", host);
            if (port != null) {
                listenerConnection.setAttribute("port", port);
            }
            listenerConfig.addContent((Content)listenerConnection);
            if (object.getAttribute("keepAlive") != null || object.getAttribute("keep-alive") != null) {
                XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"keep-alive", (String)"usePersistentConnections");
                XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)listenerConnection, (String)"keepAlive", (String)"usePersistentConnections");
            } else if (object.getAttribute("connector-ref") != null && (connector = connectorLookup.get()).getAttribute("keepAlive") != null) {
                XmlDslUtils.copyAttributeIfPresent((Element)connector, (Element)listenerConnection, (String)"keepAlive", (String)"usePersistentConnections");
            }
            XmlDslUtils.addTopLevelElement((Element)listenerConfig, (Document)object.getDocument());
            object.setAttribute("config-ref", configName);
        }
    }

    private void handleConnector(Element connector, Element listener, MigrationReport report) {
        TransportsUtils.handleServiceOverrides((Element)connector, (MigrationReport)report);
        if (connector.getAttribute("serverSoTimeout") != null || connector.getAttribute("reuseAddress") != null) {
            report.report("http.socketProperties", connector, listener, new String[0]);
            connector.removeAttribute("serverSoTimeout");
            connector.removeAttribute("reuseAddress");
        }
        if (connector.getDocument().getRootElement().getName().equals("domain")) {
            report.report("transports.domainConnector", connector, connector, new String[0]);
        }
    }

    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='connector' and @name = '" + connectorName + "']");
    }

    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='connector']");
    }

    private void handleResponseBuilder(Element listenerSource, Element listenerResponse, Element responseBuilder, Namespace httpNamespace) {
        if (responseBuilder.getChild("location", httpNamespace) != null) {
            Element location = responseBuilder.getChild("location", httpNamespace);
            listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Location").setAttribute("value", location.getAttributeValue("value")));
            location.detach();
        }
        if (responseBuilder.getChild("expires", httpNamespace) != null) {
            Element expires = responseBuilder.getChild("expires", httpNamespace);
            listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Expires").setAttribute("value", expires.getAttributeValue("value")));
            expires.detach();
        }
        if (responseBuilder.getChild("cache-control", httpNamespace) != null) {
            Element cacheControl = responseBuilder.getChild("cache-control", httpNamespace);
            if (cacheControl.getAttribute("directive") != null) {
                listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Cache-Control").setAttribute("value", cacheControl.getAttributeValue("directive")));
            }
            if (cacheControl.getAttribute("noCache") != null && "true".equals(cacheControl.getAttributeValue("noCache"))) {
                listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Cache-Control").setAttribute("value", "no-cache"));
            }
            if (cacheControl.getAttribute("noStore") != null && "true".equals(cacheControl.getAttributeValue("noStore"))) {
                listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Cache-Control").setAttribute("value", "no-store"));
            }
            if (cacheControl.getAttribute("mustRevalidate") != null && "true".equals(cacheControl.getAttributeValue("mustRevalidate"))) {
                listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Cache-Control").setAttribute("value", "must-revalidate"));
            }
            if (cacheControl.getAttribute("maxAge") != null) {
                listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Cache-Control").setAttribute("value", "max-age=" + cacheControl.getAttributeValue("maxAge")));
            }
            cacheControl.detach();
        }
        new ArrayList<Element>(responseBuilder.getChildren("set-cookie", httpNamespace)).forEach(setCookie -> {
            StringBuilder cookieBuilder = new StringBuilder();
            cookieBuilder.append(setCookie.getAttributeValue("name") + "=" + setCookie.getAttributeValue("value") + "; ");
            if (setCookie.getAttribute("domain") != null) {
                cookieBuilder.append("Domain=" + setCookie.getAttributeValue("domain") + "; ");
            }
            if (setCookie.getAttribute("path") != null) {
                cookieBuilder.append("Path=" + setCookie.getAttributeValue("path") + "; ");
            }
            if (setCookie.getAttribute("expiryDate") != null) {
                cookieBuilder.append("Expires=" + setCookie.getAttributeValue("expiryDate") + "; ");
            }
            if (setCookie.getAttribute("secure") != null) {
                cookieBuilder.append("Secure; ");
            }
            if (setCookie.getAttribute("maxAge") != null) {
                cookieBuilder.append("Max-Age=" + setCookie.getAttributeValue("maxAge") + "; ");
            }
            listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Set-Cookie").setAttribute("value", StringUtils.removeEnd((String)cookieBuilder.toString(), (String)"; ")));
            setCookie.detach();
        });
        if (!responseBuilder.getChildren("header", httpNamespace).isEmpty()) {
            new ArrayList<Element>(responseBuilder.getChildren("header", httpNamespace)).forEach(h -> {
                h.detach();
                if (h.getAttribute("name") != null) {
                    h.getAttribute("name").setName("headerName");
                }
                listenerResponse.addContent((Content)h);
            });
        }
        if (!responseBuilder.getChildren().isEmpty()) {
            listenerSource.getParentElement().addContent((Collection)responseBuilder.cloneContent());
        }
        if (responseBuilder.getAttribute("status") != null) {
            listenerResponse.setAttribute("statusCode", this.getExpressionMigrator().migrateExpression(responseBuilder.getAttributeValue("status"), false, listenerResponse));
        }
        if (responseBuilder.getAttribute("contentType") != null) {
            listenerResponse.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", "Content-Type").setAttribute("value", responseBuilder.getAttributeValue("contentType")));
        }
        responseBuilder.detach();
    }

    private Element getResponse(Element endpoint, Namespace httpNamespace) {
        Element response = endpoint.getChild("response", httpNamespace);
        if (response == null) {
            response = new Element("response", httpNamespace);
            endpoint.addContent(0, (Content)response);
        }
        return response;
    }

    private Element getErrorResponse(Element endpoint, Namespace httpNamespace) {
        Element response = endpoint.getChild("error-response", httpNamespace);
        if (response == null) {
            response = new Element("error-response", httpNamespace);
            endpoint.addContent((Content)response);
        }
        return response;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

