/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.os;

import com.mulesoft.tools.migration.library.mule.steps.os.AbstractOSMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class OSStore
extends AbstractOSMigrator {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/objectstore' and local-name() = 'store']";

    public OSStore() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        this.migrateOS(element);
        Attribute overwriteAtt = element.getAttribute("overwrite");
        if (overwriteAtt == null) {
            this.addFailAttribute(element, report);
        } else {
            if (overwriteAtt.getValue().equals("false")) {
                this.addFailAttribute(element, report);
            }
            element.removeAttribute(overwriteAtt);
        }
        Attribute valueAtt = element.getAttribute("value-ref");
        if (valueAtt != null) {
            Element childValue = new Element("value", NEW_OS_NAMESPACE);
            childValue.addContent((Content)new CDATA(this.getExpressionMigrator().migrateExpression(valueAtt.getValue(), true, element)));
            element.addContent((Content)childValue);
            element.removeAttribute(valueAtt);
        }
    }

    private void addFailAttribute(Element element, MigrationReport report) {
        element.setAttribute(new Attribute("failIfPresent", "true"));
        report.report("os.store", element, element, new String[0]);
    }
}

