/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.quartz;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Collections;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QuartzConnector
extends AbstractApplicationModelMigrationStep {
    protected static final String QUARTZ_NS_PREFIX = "quartz";
    protected static final String QUARTZ_NS_URI = "http://www.mulesoft.org/schema/mule/quartz";
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/quartz' and local-name() = 'connector']";

    public String getDescription() {
        return "Removes the connector of the quartz transport.";
    }

    public QuartzConnector() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(Namespace.getNamespace((String)QUARTZ_NS_PREFIX, (String)QUARTZ_NS_URI)));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        report.report("quartz.connector", object, object.getParentElement(), new String[0]);
        object.detach();
    }
}

