/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationPomContribution;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Collections;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ExpiredFilter
extends AbstractFilterMigrator {
    private static final String FILTERS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/filters";
    private static final Namespace FILTERS_NAMESPACE = Namespace.getNamespace((String)"filters", (String)"http://www.mulesoft.org/schema/mule/filters");
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/filters' and local-name() = 'filter-expired']";

    @Override
    public String getDescription() {
        return "Update filter-expired filter to use the validations module.";
    }

    public ExpiredFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(FILTERS_NAMESPACE));
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ExpiredFilter.addValidationNamespace(element.getDocument());
        ValidationPomContribution.addValidationDependency((PomModel)this.getApplicationModel().getPomModel().get());
        element.setName("is-not-elapsed");
        element.setNamespace(VALIDATION_NAMESPACE);
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("dateTime"), (ExpressionMigrator)this.getExpressionMigrator());
        element.getAttribute("dateTime").setName("since");
        Attribute expiresInAttr = element.getAttribute("expiresIn");
        if (expiresInAttr != null) {
            expiresInAttr.setValue(expiresInAttr.getValue());
            expiresInAttr.setName("time");
        } else {
            element.setAttribute("time", "30000");
        }
        element.setAttribute("timeUnit", "MILLISECONDS");
        this.handleFilter(element);
    }
}

