/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Collections;
import org.jdom2.Element;

public class SecurityManager
extends AbstractSpringMigratorStep {
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/spring-security' and (local-name()='security-manager')]";

    public String getDescription() {
        return "Migrates the security-manager element.";
    }

    public SecurityManager() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(SPRING_SECURITY_NAMESPACE));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(SPRING_NAMESPACE);
        for (Element provider : object.getChildren("delegate-security-provider", SPRING_SECURITY_NAMESPACE)) {
            provider.setNamespace(SPRING_NAMESPACE);
            for (Element property : provider.getChildren("security-property", SPRING_SECURITY_NAMESPACE)) {
                property.setNamespace(SPRING_NAMESPACE);
            }
        }
    }
}

