/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SpringConfigContainingMuleConfig
extends AbstractSpringMigratorStep {
    public static final String XPATH_SELECTOR = "/*[namespace-uri()='http://www.springframework.org/schema/beans' and local-name()='beans']/mule:mule";

    public String getDescription() {
        return "Migrates the outer spring config to its own file.";
    }

    public SpringConfigContainingMuleConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SPRING_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Document muleDocuemnt = object.getDocument();
        Document springDocument = this.resolveSpringDocument(muleDocuemnt);
        Document muleDoc = object.getDocument();
        Element springRoot = object.getDocument().detachRootElement();
        object.detach();
        springDocument.setRootElement(springRoot);
        muleDoc.setRootElement(object);
        object.addContent(1, (Content)springDocument.getRootElement().getChild("config", SPRING_NAMESPACE).detach());
        this.moveNamespacesDeclarations(muleDocuemnt, springDocument.getRootElement(), springDocument);
    }
}

