/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools;

import java.util.Stack;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateParser {
    public static final String WIGGLY_MULE_TEMPLATE_STYLE = "mule";
    private static final char START_EXPRESSION = '#';
    private static final char OPEN_EXPRESSION = '[';
    private static final char CLOSE_EXPRESSION = ']';
    public static final String MEL_PREFIX = "mel:";
    protected static final Logger logger = LoggerFactory.getLogger(TemplateParser.class);
    private final PatternInfo style = new PatternInfo("mule", "#\\[((?:#?\\[(?:#?\\[(?:#?\\[(?:#?\\[(?:#?\\[.*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?)\\]", "#[", "]");

    public static TemplateParser createMuleStyleParser() {
        return new TemplateParser();
    }

    private TemplateParser() {
    }

    public String translate(String template, ScriptTranslator callback) {
        if (!this.validateBalanceMuleStyle(template)) {
            return template;
        }
        template = template.replaceAll("\\\"", "'");
        boolean lastIsBackSlash = false;
        boolean lastStartedExpression = false;
        boolean openDoubleQuotes = false;
        StringBuilder result = new StringBuilder("#[\"");
        for (int currentPosition = 0; currentPosition < template.length(); ++currentPosition) {
            char c = template.charAt(currentPosition);
            if (lastStartedExpression && c != '[') {
                result.append('#');
            }
            if (lastIsBackSlash && c != '\'' && c != '\"') {
                result.append("\\");
            }
            if (!lastIsBackSlash && c == '\"') {
                boolean bl = openDoubleQuotes = !openDoubleQuotes;
            }
            if (c == '[' && lastStartedExpression && !openDoubleQuotes) {
                int closing = this.closingBracesPosition(template, currentPosition);
                String enclosingTemplate = template.substring(currentPosition + 1, closing);
                if (enclosingTemplate.startsWith(MEL_PREFIX)) {
                    enclosingTemplate = enclosingTemplate.substring(MEL_PREFIX.length());
                }
                String value = callback.translate(enclosingTemplate);
                result.append("$(").append(value).append(")");
                currentPosition = closing;
            } else if (c != '#' && c != '\\') {
                result.append(c);
            }
            lastStartedExpression = c == '#';
            lastIsBackSlash = c == '\\';
        }
        return result.append("\"]").toString();
    }

    private int closingBracesPosition(String template, int startingPosition) {
        int openingBraces = 1;
        boolean lastIsBackSlash = false;
        boolean openSingleQuotes = false;
        boolean openDoubleQuotes = false;
        for (int i = startingPosition + 1; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == ']' && !openSingleQuotes && !openDoubleQuotes) {
                --openingBraces;
            } else if (c == '[' && !openSingleQuotes && !openDoubleQuotes) {
                ++openingBraces;
            } else if (!lastIsBackSlash && c == '\'') {
                openSingleQuotes = !openSingleQuotes;
            } else if (!lastIsBackSlash && c == '\"') {
                openDoubleQuotes = !openDoubleQuotes;
            }
            boolean bl = lastIsBackSlash = c == '\\';
            if (openingBraces != 0) continue;
            return i;
        }
        return -1;
    }

    private boolean styleIs(String style) {
        return this.getStyle().getName().equals(style);
    }

    private boolean validateBalanceMuleStyle(String template) {
        Stack<Character> stack = new Stack<Character>();
        boolean lastStartedExpression = false;
        boolean lastIsBackSlash = false;
        int openBraces = 0;
        int openSingleQuotes = 0;
        int openDoubleQuotes = 0;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            switch (c) {
                case '\'': {
                    if (lastIsBackSlash) break;
                    if (!stack.empty() && ((Character)stack.peek()).equals(Character.valueOf('\''))) {
                        stack.pop();
                        --openSingleQuotes;
                        break;
                    }
                    stack.push(Character.valueOf(c));
                    ++openSingleQuotes;
                    break;
                }
                case '\"': {
                    if (lastIsBackSlash) break;
                    if (!stack.empty() && ((Character)stack.peek()).equals(Character.valueOf('\"'))) {
                        stack.pop();
                        --openDoubleQuotes;
                        break;
                    }
                    stack.push(Character.valueOf(c));
                    ++openDoubleQuotes;
                    break;
                }
                case ']': {
                    if (stack.empty() || !((Character)stack.peek()).equals(Character.valueOf('['))) break;
                    stack.pop();
                    --openBraces;
                    break;
                }
                case '[': {
                    if (!lastStartedExpression && openBraces <= 0 || openDoubleQuotes > 0 || openSingleQuotes > 0) break;
                    stack.push(Character.valueOf(c));
                    ++openBraces;
                }
            }
            lastStartedExpression = c == '#';
            lastIsBackSlash = c == '\\';
        }
        return stack.empty();
    }

    private PatternInfo getStyle() {
        return this.style;
    }

    public static class PatternInfo {
        String name;
        String regEx;
        String prefix;
        String suffix;

        PatternInfo(String name, String regEx, String prefix, String suffix) {
            this.name = name;
            this.regEx = regEx;
            if (prefix.length() < 1 || prefix.length() > 2) {
                throw new IllegalArgumentException("Prefix can only be one or two characters long: " + prefix);
            }
            this.prefix = prefix;
            if (suffix.length() != 1) {
                throw new IllegalArgumentException("Suffix can only be one character long: " + suffix);
            }
            this.suffix = suffix;
        }

        public String getName() {
            return this.name;
        }

        public Pattern getPattern() {
            return Pattern.compile(this.regEx, 2);
        }
    }

    @FunctionalInterface
    public static interface ScriptTranslator {
        public String translate(String var1);
    }
}

