/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel;

import com.mulesoft.tools.migration.library.tools.MelToDwExpressionMigrator;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class Encode64Resolver
implements CompatibilityResolver<String> {
    private final Pattern base64Method = Pattern.compile("^\\s*org\\.apache\\.commons\\.codec\\.binary\\.Base64\\.encodeBase64\\s*\\((.*)?\\)\\s*$");

    public boolean canResolve(String original) {
        return this.base64Method.matcher(original).matches();
    }

    public String resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator) {
        Matcher base64MethodMatcher = this.base64Method.matcher(original = original.trim());
        if (base64MethodMatcher.matches() && base64MethodMatcher.groupCount() > 0 && base64MethodMatcher.group().equals(original)) {
            String innerExpression = base64MethodMatcher.group(1).replace(".getBytes()", "");
            if (!(innerExpression = ((MelToDwExpressionMigrator)expressionMigrator).translateSingleExpression(innerExpression, true, element, false)).startsWith("mel:")) {
                return "dw::core::Binaries::toBase64(" + innerExpression + ")";
            }
        }
        report.report("expressions.encodeBase64", element, element, new String[0]);
        return original;
    }
}

