/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine.project.structure;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class BasicProject {
    protected Path baseFolder;

    public BasicProject(Path baseFolder) {
        Preconditions.checkArgument((baseFolder != null ? 1 : 0) != 0, (Object)"The base folder path must not be null");
        if (!baseFolder.toFile().exists()) {
            baseFolder.toFile().mkdirs();
        }
        this.baseFolder = baseFolder.toAbsolutePath();
    }

    public Path getBaseFolder() {
        return this.baseFolder;
    }

    public static List<Path> getFiles(Path path, String ... extensions) throws Exception {
        String[] filter = extensions.length != 0 ? extensions : null;
        Collection files = FileUtils.listFiles((File)path.toFile(), (String[])filter, (boolean)true);
        return files.stream().map(f -> f.toPath()).collect(Collectors.toList());
    }
}

