/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.report.html;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.report.html.ReportFileWriter;
import com.mulesoft.tools.migration.report.html.model.ApplicationReport;
import com.mulesoft.tools.migration.report.html.model.ReportEntryModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HTMLReport {
    private static final String ASSETS_FOLDER = "assets";
    private static final String RESOURCES_FOLDER = "resources";
    private static final String STYLES_FOLDER = "styles";
    private static final String SCRIPTS_FOLDER = "js";
    private static final String BASE_TEMPLATE_FOLDER = "/templates";
    private static final String SUMMARY_TEMPLATE_FILE_NAME = "summary.ftl";
    private static final String RESOURCE_TEMPLATE_FILE_NAME = "resource.ftl";
    private static final String JQUERY_SCRIPT = "jquery-3.3.1.js";
    private static final String MULESOFT_STYLES = "mulesoft-styles.css";
    private static final String MULESOFT_ICON = "icons/004_logo.svg";
    private static final String MULESOFT_ICON_TTF = "fonts/muleicons.ttf";
    private final File reportDirectory;
    private ApplicationReport applicationReport;
    private ReportFileWriter reportFileWriter = new ReportFileWriter();
    private Configuration freemarkerConfig;
    private String runnerVersion;

    public HTMLReport(List<ReportEntryModel> reportEntries, File reportDirectory, String runnerVersion) {
        Preconditions.checkNotNull(reportEntries, (Object)"Report Entries cannot be null");
        Preconditions.checkNotNull((Object)reportDirectory, (Object)"Report directory cannot be null");
        this.applicationReport = new ApplicationReport.ApplicationReportBuilder().withReportEntries(reportEntries).build();
        this.reportDirectory = reportDirectory;
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_28);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), BASE_TEMPLATE_FOLDER);
        this.runnerVersion = runnerVersion;
    }

    public void printReport() {
        try {
            this.printSummary();
            this.printResources();
            this.addAssets();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReportFileWriter(ReportFileWriter reportFileWriter) {
        this.reportFileWriter = reportFileWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSummary() throws IOException {
        StringWriter writer = null;
        try {
            Template summaryTemplate = this.getTemplate(SUMMARY_TEMPLATE_FILE_NAME);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("version", this.runnerVersion);
            data.put("applicationErrors", this.applicationReport.getErrorEntries());
            data.put("applicationWarnings", this.applicationReport.getWarningEntries());
            data.put("applicationInfo", this.applicationReport.getInfoEntries());
            data.put("applicationSummaryErrors", this.applicationReport.getSummaryErrorEntries());
            data.put("applicationSummaryWarnings", this.applicationReport.getSummaryWarningEntries());
            data.put("applicationSummaryInfo", this.applicationReport.getSummaryInfoEntries());
            writer = new StringWriter();
            summaryTemplate.process(data, (Writer)writer);
            this.reportFileWriter.writeToFile(new File(this.reportDirectory, "summary.html"), writer.getBuffer().toString());
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private void printResources() throws IOException {
        this.generateResourceFiles(this.applicationReport.getErrorEntries(), MigrationReport.Level.ERROR);
        this.generateResourceFiles(this.applicationReport.getWarningEntries(), MigrationReport.Level.WARN);
        this.generateResourceFiles(this.applicationReport.getInfoEntries(), MigrationReport.Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateResourceFiles(Map<String, Map<String, List<ReportEntryModel>>> entries, MigrationReport.Level level) throws IOException {
        StringWriter writer = null;
        for (Map.Entry<String, Map<String, List<ReportEntryModel>>> entry : entries.entrySet()) {
            Integer fileCounter = 0;
            for (Map.Entry<String, List<ReportEntryModel>> fileEntry : entry.getValue().entrySet()) {
                try {
                    if (fileEntry.getValue().size() > 0) {
                        Template resourceTemplate = this.getTemplate(RESOURCE_TEMPLATE_FILE_NAME);
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("version", this.runnerVersion);
                        data.put("resource", Paths.get(entry.getKey(), new String[0]).getFileName().toString());
                        data.put("description", fileEntry.getKey());
                        data.put("docLinks", fileEntry.getValue().get(0).getDocumentationLinks());
                        data.put("entries", fileEntry.getValue());
                        String fileName = level.toString().toLowerCase() + "-" + Paths.get(entry.getKey(), new String[0]).getFileName().toString();
                        writer = new StringWriter();
                        resourceTemplate.process(data, (Writer)writer);
                        this.reportFileWriter.writeToFile(new File(this.reportDirectory.toPath().resolve(RESOURCES_FOLDER).toFile(), this.reportFileWriter.getHtmlFileName(fileName, fileCounter)), writer.getBuffer().toString());
                    }
                }
                catch (TemplateException e) {
                    e.printStackTrace();
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
                Integer n = fileCounter;
                Integer n2 = fileCounter = Integer.valueOf(fileCounter + 1);
            }
        }
    }

    private Template getTemplate(String resourceTemplateFileName) throws IOException {
        return this.freemarkerConfig.getTemplate(resourceTemplateFileName, Locale.US);
    }

    private void addAssets() {
        this.addStyles();
        this.addScripts();
    }

    private void addStyles() {
        try {
            Path stylesPath = this.reportDirectory.toPath().resolve(ASSETS_FOLDER).resolve(STYLES_FOLDER);
            this.reportFileWriter.copyFile(MULESOFT_STYLES, stylesPath.resolve(MULESOFT_STYLES).toFile());
            this.reportFileWriter.copyFile(MULESOFT_ICON, stylesPath.resolve(MULESOFT_ICON).toFile());
            this.reportFileWriter.copyFile(MULESOFT_ICON_TTF, stylesPath.resolve(MULESOFT_ICON_TTF).toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addScripts() {
        try {
            Path scriptsPath = this.reportDirectory.toPath().resolve(ASSETS_FOLDER).resolve(SCRIPTS_FOLDER);
            this.reportFileWriter.copyFile(JQUERY_SCRIPT, scriptsPath.resolve(JQUERY_SCRIPT).toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

