/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration;

import com.google.common.base.Stopwatch;
import com.mulesoft.tools.migration.engine.MigrationJob;
import com.mulesoft.tools.migration.exception.ConsoleOptionsException;
import com.mulesoft.tools.migration.printer.ConsolePrinter;
import com.mulesoft.tools.migration.report.DefaultMigrationReport;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MigrationRunner {
    private static final String HELP = "help";
    private static final String PROJECT_BASE_PATH = "projectBasePath";
    private static final String PARENT_DOMAIN_BASE_PATH = "parentDomainBasePath";
    private static final String DESTINATION_PROJECT_BASE_PATH = "destinationProjectBasePath";
    private static final String MULE_VERSION = "muleVersion";
    private static final String REPORT_HOME = "summary.html";
    public static final String MULE_3_VERSION = "3.*.*";
    private String projectBasePath;
    private String parentDomainProjectBasePath;
    private String destinationProjectBasePath;
    private String muleVersion;
    private String userId;
    private String sessionId;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPass;

    public static void main(String[] args) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        MigrationRunner migrationRunner = MigrationRunner.buildRunner(args);
        MigrationJob job = migrationRunner.buildMigrationJob();
        try {
            DefaultMigrationReport report = new DefaultMigrationReport();
            ConsolePrinter.log("Executing migrator " + job.getRunnerVersion() + "...");
            job.execute((MigrationReport)report);
            ConsolePrinter.printMigrationSummary(job.getReportPath().resolve(REPORT_HOME).toAbsolutePath().toString(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), report);
            System.exit(0);
        }
        catch (Exception ex) {
            ConsolePrinter.printMigrationError(ex, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            System.exit(-1);
        }
    }

    protected static MigrationRunner buildRunner(String[] args) throws Exception {
        MigrationRunner migrationRunner = new MigrationRunner();
        migrationRunner.initializeOptions(args);
        return migrationRunner;
    }

    private MigrationJob buildMigrationJob() throws Exception {
        return new MigrationJob.MigrationJobBuilder().withProject(Paths.get(this.projectBasePath, new String[0])).withParentDomainProject(this.parentDomainProjectBasePath != null ? Paths.get(this.parentDomainProjectBasePath, new String[0]) : null).withOutputProject(Paths.get(this.destinationProjectBasePath, new String[0])).withInputVersion(MULE_3_VERSION).withOuputVersion(this.muleVersion).build();
    }

    private void initializeOptions(String[] args) {
        Options options = new Options();
        options.addOption(HELP, false, "Shows the help");
        options.addOption(PROJECT_BASE_PATH, true, "Base directory of the project to be migrated");
        options.addOption(PARENT_DOMAIN_BASE_PATH, true, "Base directory of the parent domain of the project to be migrated, if any");
        options.addOption(DESTINATION_PROJECT_BASE_PATH, true, "Base directory of the migrated project");
        options.addOption(MULE_VERSION, true, "Mule version where to migrate project");
        options.addOption("userId", true, "The userId to send for the usage statistics");
        options.addOption("sessionId", true, "The sessionId to send for the usage statistics");
        options.addOption("proxyHost", true, "The host of the proxy to use when sending usage statistics");
        options.addOption("proxyPort", true, "The port of the proxy to use when sending usage statistics");
        options.addOption("proxyUser", true, "The username of the proxy to use when sending usage statistics");
        options.addOption("proxyPass", true, "The password of the proxy to use when sending usage statistics");
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(options, args);
            if (!line.hasOption(PROJECT_BASE_PATH)) {
                throw new ConsoleOptionsException("You must specify a project base path of the files to be migrated");
            }
            this.projectBasePath = line.getOptionValue(PROJECT_BASE_PATH);
            if (line.hasOption(PARENT_DOMAIN_BASE_PATH)) {
                this.parentDomainProjectBasePath = line.getOptionValue(PARENT_DOMAIN_BASE_PATH);
            }
            if (!line.hasOption(DESTINATION_PROJECT_BASE_PATH)) {
                throw new ConsoleOptionsException("You must specify a destination project base path");
            }
            this.destinationProjectBasePath = line.getOptionValue(DESTINATION_PROJECT_BASE_PATH);
            if (!line.hasOption(MULE_VERSION)) {
                throw new ConsoleOptionsException("You must specify a destination project base path");
            }
            this.muleVersion = line.getOptionValue(MULE_VERSION);
            if (line.hasOption(HELP)) {
                this.printHelp(options);
            }
            this.userId = line.hasOption("userId") ? line.getOptionValue("userId") : UUID.randomUUID().toString();
            this.sessionId = line.hasOption("sessionId") ? line.getOptionValue("sessionId") : "111111111";
            if (line.hasOption("proxyHost")) {
                this.proxyHost = line.getOptionValue("proxyHost");
            }
            if (line.hasOption("proxyPort")) {
                this.proxyPort = Integer.parseInt(line.getOptionValue("proxyPort"));
            }
            if (line.hasOption("proxyUser")) {
                this.proxyUser = line.getOptionValue("proxyUser");
            }
            if (line.hasOption("proxyPass")) {
                this.proxyPass = line.getOptionValue("proxyPass");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ConsoleOptionsException e) {
            this.printHelp(options);
            System.exit(-1);
        }
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("migration-assistant - Help", options);
    }
}

