/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.pom;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.PluginExecution;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class Plugin {
    private final org.apache.maven.model.Plugin plugin;

    protected Plugin(org.apache.maven.model.Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin() {
        this.plugin = new org.apache.maven.model.Plugin();
    }

    protected org.apache.maven.model.Plugin getInnerModel() {
        return this.plugin;
    }

    public String getArtifactId() {
        return this.plugin.getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        this.plugin.setArtifactId(artifactId);
    }

    public String getGroupId() {
        return this.plugin.getGroupId();
    }

    public void setGroupId(String groupId) {
        this.plugin.setGroupId(groupId);
    }

    public String getVersion() {
        return this.plugin.getVersion();
    }

    public void setVersion(String version) {
        this.plugin.setVersion(version);
    }

    public List<Dependency> getDependencies() {
        return this.plugin.getDependencies().stream().map(Dependency::new).collect(Collectors.toList());
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.plugin.setDependencies(dependencies.stream().map(Dependency::getInnerModel).collect(Collectors.toList()));
    }

    public List<PluginExecution> getExecutions() {
        return this.plugin.getExecutions().stream().map(PluginExecution::new).collect(Collectors.toList());
    }

    public boolean setExecutions(List<PluginExecution> executions) {
        if (PluginBuilder.areAllExecutionIdsUnique(executions)) {
            this.plugin.setExecutions(executions.stream().map(PluginExecution::getInnerModel).collect(Collectors.toList()));
            return true;
        }
        return false;
    }

    public String getExtensions() {
        return this.plugin.getExtensions();
    }

    public void setExtensions(String extensions) {
        if (StringUtils.equals((CharSequence)"true", (CharSequence)extensions) || StringUtils.equals((CharSequence)"false", (CharSequence)extensions)) {
            this.plugin.setExtensions(extensions);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin that = (Plugin)o;
        return Objects.equals(this.plugin, that.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.plugin);
    }

    public Xpp3Dom getConfiguration() {
        Xpp3Dom configuration = (Xpp3Dom)this.plugin.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            this.plugin.setConfiguration((Object)configuration);
        }
        return configuration;
    }

    public static class PluginBuilder {
        private String artifactId;
        private String groupId;
        private String version;
        private List<Dependency> dependencies;
        private List<PluginExecution> executions;
        private String extensions;

        public PluginBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public PluginBuilder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public PluginBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public PluginBuilder withDependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public PluginBuilder withExecutions(List<PluginExecution> executions) {
            this.executions = executions;
            return this;
        }

        public PluginBuilder withExtensions(String extensions) {
            this.extensions = extensions;
            return this;
        }

        public Plugin build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.artifactId), (Object)"Artifact id cannot be null nor empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupId), (Object)"Group id cannot be null nor empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.version), (Object)"Version cannot be null nor empty");
            Plugin plugin = new Plugin();
            plugin.setArtifactId(this.artifactId);
            plugin.setGroupId(this.groupId);
            plugin.setVersion(this.version);
            if (this.dependencies != null) {
                plugin.setDependencies(this.dependencies);
            }
            if (this.executions != null) {
                Preconditions.checkArgument((boolean)PluginBuilder.areAllExecutionIdsUnique(this.executions), (Object)"Execution ids should be unique");
                plugin.setExecutions(this.executions);
            }
            if (this.extensions != null) {
                plugin.setExtensions(this.extensions);
            }
            return plugin;
        }

        protected static boolean areAllExecutionIdsUnique(List<PluginExecution> executions) {
            return executions.size() == executions.stream().map(PluginExecution::getId).collect(Collectors.toSet()).size();
        }
    }
}

