/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractUnsupportedElementsMigrationStep
extends AbstractApplicationModelMigrationStep {
    public static final String COMPONENTS_UNSUPPORTED_ERROR_KEY = "components.unsupported";
    public static final String NAME_ATTRIBUTE_TEMPLATE = "(name = %s)";

    public AbstractUnsupportedElementsMigrationStep(Namespace namespace) {
        Preconditions.checkArgument((this.getUnsupportedElements() != null ? 1 : 0) != 0, (Object)"The unsupported elements list must not be null.");
        this.setAppliedTo(XmlDslUtils.getAllElementsFromNamespaceXpathSelector(namespace.getURI(), this.getUnsupportedElements(), false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{namespace}));
    }

    public abstract List<String> getUnsupportedElements();

    @Override
    public void execute(Element node, MigrationReport report) throws RuntimeException {
        if (this.getUnsupportedElements().contains(node.getName())) {
            report.report(COMPONENTS_UNSUPPORTED_ERROR_KEY, node, node, report.getComponentKey(node) + " " + String.format(NAME_ATTRIBUTE_TEMPLATE, node.getAttributeValue("name")));
        }
    }
}

