/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.step;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.ApplicationModelContribution;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPathExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingStep
implements ApplicationModelContribution,
ExpressionMigratorAware {
    private static final Logger logger = LoggerFactory.getLogger(ReportingStep.class);
    private final ApplicationModelContribution targetStep;

    public ReportingStep(ApplicationModelContribution step) {
        this.targetStep = step;
    }

    @Override
    public void execute(Element element, MigrationReport report) {
        int entriesBefore = report.getReportEntries(MigrationReport.Level.ERROR).size();
        int melFailuresBefore = report.getMelExpressionsFailureCount();
        int dwFailuresBefore = report.getDwTransformsFailureCount();
        try {
            this.targetStep.execute(element, report);
            if (this.targetStep.shouldReportMetrics()) {
                if (report.getReportEntries(MigrationReport.Level.ERROR).size() <= entriesBefore + (report.getMelExpressionsFailureCount() - melFailuresBefore) + (report.getDwTransformsFailureCount() - dwFailuresBefore)) {
                    report.addComponentSuccess(element);
                } else {
                    report.addComponentFailure(element);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception {} -- migrating {}:{}", new Object[]{e, element != null ? element.getNamespacePrefix() : "null", element != null ? element.getName() : "null"});
            if (this.targetStep.shouldReportMetrics()) {
                report.addComponentFailure(element);
            }
            throw e;
        }
    }

    @Override
    public String getDescription() {
        return this.targetStep.getDescription();
    }

    @Override
    public XPathExpression getAppliedTo() {
        return this.targetStep.getAppliedTo();
    }

    @Override
    public void setAppliedTo(String xpathExpression) {
        this.targetStep.setAppliedTo(xpathExpression);
    }

    @Override
    public ApplicationModel getApplicationModel() {
        return this.targetStep.getApplicationModel();
    }

    @Override
    public void setApplicationModel(ApplicationModel appModel) {
        this.targetStep.setApplicationModel(appModel);
    }

    @Override
    public List<Namespace> getNamespacesContributions() {
        return this.targetStep.getNamespacesContributions();
    }

    @Override
    public void setNamespacesContributions(List<Namespace> namespaces) {
        this.targetStep.setNamespacesContributions(namespaces);
    }

    @Override
    public boolean shouldReportMetrics() {
        return this.targetStep.shouldReportMetrics();
    }

    @Override
    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        if (this.targetStep instanceof ExpressionMigratorAware) {
            ((ExpressionMigratorAware)((Object)this.targetStep)).setExpressionMigrator(expressionMigrator);
        }
    }

    @Override
    public ExpressionMigrator getExpressionMigrator() {
        if (this.targetStep instanceof ExpressionMigratorAware) {
            return ((ExpressionMigratorAware)((Object)this.targetStep)).getExpressionMigrator();
        }
        return null;
    }
}

