/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.step.util;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class TransportsUtils {
    private static final String COMPATIBILITY_NS_URI = "http://www.mulesoft.org/schema/mule/compatibility";
    protected static final String COMPATIBILITY_NS_SCHEMA_LOC = "http://www.mulesoft.org/schema/mule/compatibility/current/mule-compatibility.xsd";
    public static final Namespace COMPATIBILITY_NAMESPACE = Namespace.getNamespace((String)"compatibility", (String)"http://www.mulesoft.org/schema/mule/compatibility");
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("((?:\\w+|\\$\\{[^\\}]*\\})):\\/\\/(?:(.*)@)?([^\\/:]*)(?::([^\\/]+))?(\\/.*)?");

    private TransportsUtils() {
    }

    public static Optional<EndpointAddress> processAddress(Element endpoint, MigrationReport report) {
        if (endpoint.getAttribute("address") == null) {
            return Optional.empty();
        }
        String address = endpoint.getAttributeValue("address");
        Matcher addressMatcher = ADDRESS_PATTERN.matcher(address);
        if (addressMatcher.matches()) {
            String protocol = addressMatcher.group(1);
            String credentials = addressMatcher.group(2);
            String host = addressMatcher.group(3);
            String port = addressMatcher.group(4);
            String path = addressMatcher.group(5);
            endpoint.removeAttribute("address");
            if ("file".equals(protocol) || "jms".equals(protocol) || "vm".equals(protocol)) {
                return Optional.of(new EndpointAddress(protocol, credentials, null, port, host + (path != null ? path : "")));
            }
            return Optional.of(new EndpointAddress(protocol, credentials, host, port, path));
        }
        report.report("transports.cantParseAddress", endpoint, endpoint, address);
        endpoint.removeAttribute("address");
        return Optional.of(new EndpointAddress(null, null, address, null, null));
    }

    public static void handleReconnection(Element mule3Connector, Element connection, MigrationReport report) {
        XmlDslUtils.migrateReconnection(connection, mule3Connector, report);
    }

    public static void handleConnectorChildElements(Element element, Element flow, Element connection, MigrationReport report) {
        Element reconnect;
        Element dispatcherThreadingProfile;
        Element receiverThreadingProfile = element.getChild("receiver-threading-profile", XmlDslUtils.CORE_NAMESPACE);
        if (receiverThreadingProfile != null) {
            report.report("flow.threading", receiverThreadingProfile, flow, new String[0]);
            element.removeContent((Content)receiverThreadingProfile);
        }
        if ((dispatcherThreadingProfile = element.getChild("dispatcher-threading-profile", XmlDslUtils.CORE_NAMESPACE)) != null) {
            report.report("flow.threading", dispatcherThreadingProfile, flow, new String[0]);
            element.removeContent((Content)dispatcherThreadingProfile);
        }
        if ((reconnect = element.getChild("reconnect", XmlDslUtils.CORE_NAMESPACE)) != null) {
            Element reconnectNotification = reconnect.getChild("reconnect-custom-notifier", XmlDslUtils.CORE_NAMESPACE);
            if (reconnectNotification != null) {
                report.report("transports.reconnectCustomNotifier", dispatcherThreadingProfile, flow, new String[0]);
                reconnectNotification.detach();
            }
            reconnect.removeAttribute("blocking");
            Element reconnection = connection.getChild("reconnection", XmlDslUtils.CORE_NAMESPACE);
            if (reconnection == null) {
                reconnection = new Element("reconnection", XmlDslUtils.CORE_NAMESPACE);
                connection.addContent((Content)reconnection);
            }
            XmlDslUtils.copyAttributeIfPresent(reconnect, reconnection, "frequency");
            XmlDslUtils.copyAttributeIfPresent(reconnect, reconnection, "count");
            if (reconnect.getAttributes().size() == 0 && reconnect.getChildren().isEmpty()) {
                reconnect.detach();
            }
        }
    }

    public static void migrateInboundEndpointStructure(ApplicationModel appModel, Element inboundEndpoint, MigrationReport report, boolean expectsOutboundProperties) {
        TransportsUtils.migrateInboundEndpointStructure(appModel, inboundEndpoint, report, expectsOutboundProperties, false);
    }

    public static void migrateInboundEndpointStructure(ApplicationModel appModel, Element inboundEndpoint, MigrationReport report, boolean expectsOutboundProperties, boolean consumeStreams) {
        inboundEndpoint.removeAttribute("exchange-pattern");
        inboundEndpoint.removeAttribute("disableTransportTransformer");
        TransportsUtils.extractInboundChildren(inboundEndpoint, appModel);
        XmlDslUtils.migrateSourceStructure(appModel, inboundEndpoint, report, expectsOutboundProperties, consumeStreams);
    }

    public static void migrateOutboundEndpointStructure(ApplicationModel appModel, Element outboundEndpoint, MigrationReport report, boolean outputsAttributes) {
        TransportsUtils.migrateOutboundEndpointStructure(appModel, outboundEndpoint, report, outputsAttributes, false);
    }

    public static void migrateOutboundEndpointStructure(ApplicationModel appModel, Element outboundEndpoint, MigrationReport report, boolean outputsAttributes, boolean consumeStreams) {
        if (outboundEndpoint.getAttributeValue("exchange-pattern") != null && "one-way".equals(outboundEndpoint.getAttributeValue("exchange-pattern"))) {
            Element asyncWrapper;
            Element nestedAsync = asyncWrapper = new Element("async", XmlDslUtils.CORE_NAMESPACE);
            Element flow = outboundEndpoint.getParentElement();
            Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement(flow);
            if (errorHandler != null) {
                nestedAsync = new Element("try", XmlDslUtils.CORE_NAMESPACE);
                asyncWrapper.addContent((Content)nestedAsync);
            }
            List allChildren = flow.getChildren();
            for (Element processor : new ArrayList(allChildren.subList(allChildren.indexOf(outboundEndpoint), allChildren.size()))) {
                if (!XmlDslUtils.isErrorHanldingElement(processor)) {
                    nestedAsync.addContent((Content)processor.detach());
                    continue;
                }
                nestedAsync.addContent((Content)processor.clone());
            }
            if (errorHandler != null) {
                flow.addContent(flow.indexOf((Content)errorHandler), (Content)asyncWrapper);
            } else {
                flow.addContent((Content)asyncWrapper);
            }
        }
        outboundEndpoint.removeAttribute("exchange-pattern");
        outboundEndpoint.removeAttribute("disableTransportTransformer");
        TransportsUtils.extractOutboundChildren(outboundEndpoint, appModel);
        XmlDslUtils.migrateOperationStructure(appModel, outboundEndpoint, report, outputsAttributes, null, null, consumeStreams);
    }

    public static void extractInboundChildren(Element inbound, ApplicationModel appModel) {
        TransportsUtils.extractInboundChildren(inbound, 2, inbound.getParentElement(), appModel);
    }

    public static void extractInboundChildren(Element inbound, int index, Element target, ApplicationModel appModel) {
        target.addContent(index, TransportsUtils.fetchContent(inbound, appModel));
        Element flow = target;
        Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement(flow);
        if (errorHandler != null) {
            flow.addContent(flow.indexOf((Content)errorHandler), TransportsUtils.fetchResponseContent(inbound, appModel));
        } else {
            flow.addContent(TransportsUtils.fetchResponseContent(inbound, appModel));
        }
    }

    public static void extractOutboundChildren(Element outbound, ApplicationModel appModel) {
        outbound.getParentElement().addContent(outbound.getParentElement().indexOf((Content)outbound), TransportsUtils.fetchContent(outbound, appModel));
        outbound.getParentElement().addContent(outbound.getParentElement().indexOf((Content)outbound) + 1, TransportsUtils.fetchResponseContent(outbound, appModel));
    }

    private static List<Content> fetchContent(Element endpoint, ApplicationModel appModel) {
        ArrayList<Content> content = new ArrayList<Content>();
        if (endpoint.getChild("properties", XmlDslUtils.CORE_NAMESPACE) != null) {
            for (Element element : endpoint.getChild("properties", XmlDslUtils.CORE_NAMESPACE).getChildren()) {
                if (!"entry".equals(element.getName()) || !"http://www.springframework.org/schema/beans".equals(element.getNamespace().getURI())) continue;
                content.add((Content)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", element.getAttributeValue("key")).setAttribute("value", element.getAttributeValue("value")));
            }
            endpoint.getChild("properties", XmlDslUtils.CORE_NAMESPACE).detach();
        }
        if (endpoint.getAttribute("transformer-refs") != null) {
            String[] transformerNames;
            for (String transformerName : transformerNames = endpoint.getAttributeValue("transformer-refs").split(",")) {
                Element transformer = appModel.getNode("/*/*[@name = '" + transformerName + "']");
                if ("message-properties-transformer".equals(transformer.getName())) {
                    Element clonedMpt = transformer.clone();
                    clonedMpt.removeAttribute("name");
                    content.add((Content)clonedMpt);
                    continue;
                }
                content.add((Content)new Element("transformer", XmlDslUtils.CORE_NAMESPACE).setAttribute("ref", transformerName));
            }
            endpoint.removeAttribute("transformer-refs");
        }
        endpoint.getChildren().stream().filter(c -> c.getName().contains("transformer") || c.getName().contains("filter") || "set-property".equals(c.getName()) || "processor".equals(c.getName()) || "logger".equals(c.getName())).collect(Collectors.toList()).forEach(tc -> {
            tc.getParent().removeContent((Content)tc);
            content.add((Content)tc);
        });
        return content;
    }

    private static List<Content> fetchResponseContent(Element endpoint, ApplicationModel appModel) {
        ArrayList<Content> responseContent = new ArrayList<Content>();
        if (endpoint.getChild("response", XmlDslUtils.CORE_NAMESPACE) != null) {
            responseContent.addAll(endpoint.getChild("response", XmlDslUtils.CORE_NAMESPACE).cloneContent());
            endpoint.getChild("response", XmlDslUtils.CORE_NAMESPACE).detach();
        }
        if (endpoint.getAttribute("responseTransformer-refs") != null) {
            String[] transformerNames;
            for (String transformerName : transformerNames = endpoint.getAttributeValue("responseTransformer-refs").split(",")) {
                Element transformer = appModel.getNode("/*/*[@name = '" + transformerName + "']");
                if ("message-properties-transformer".equals(transformer.getName())) {
                    Element clonedMpt = transformer.clone();
                    clonedMpt.removeAttribute("name");
                    responseContent.add((Content)clonedMpt);
                    continue;
                }
                responseContent.add((Content)new Element("transformer", XmlDslUtils.CORE_NAMESPACE).setAttribute("ref", transformerName));
            }
            endpoint.removeAttribute("responseTransformer-refs");
        }
        return responseContent;
    }

    public static void migrateSchedulingStrategy(Element endpoint, OptionalInt defaultFreq) {
        Element fixedFrequency;
        Element schedulingStr = endpoint.getChild("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE);
        if (schedulingStr == null) {
            schedulingStr = new Element("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE);
            schedulingStr.addContent((Content)new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE));
            endpoint.addContent((Content)schedulingStr);
        }
        if ((fixedFrequency = schedulingStr.getChild("fixed-frequency", XmlDslUtils.CORE_NAMESPACE)) != null) {
            if (endpoint.getAttribute("pollingFrequency") != null) {
                fixedFrequency.setAttribute("frequency", endpoint.getAttributeValue("pollingFrequency", "1000"));
            } else if (fixedFrequency.getAttribute("frequency") == null) {
                defaultFreq.ifPresent(df -> fixedFrequency.setAttribute("frequency", Integer.toString(df)));
            }
            endpoint.removeAttribute("pollingFrequency");
        }
    }

    public static void handleServiceOverrides(Element connector, MigrationReport report) {
        Element serviceOverrides = connector.getChild("service-override", XmlDslUtils.CORE_NAMESPACE);
        if (serviceOverrides != null) {
            report.report("transports.serviceOverrides", serviceOverrides, connector, new String[0]);
            serviceOverrides.detach();
        }
    }

    public static final class EndpointAddress {
        private final String protocol;
        private final String credentials;
        private final String host;
        private final String port;
        private final String path;

        public EndpointAddress(String protocol, String credentials, String host, String port, String path) {
            this.protocol = protocol;
            this.credentials = credentials;
            this.host = host;
            this.port = port;
            this.path = path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getCredentials() {
            return this.credentials;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getPath() {
            return this.path;
        }
    }
}

