/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit;

import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ApikitUriParamUtils {
    private static final String DOCS_NAMESPACE_URL = "http://www.mulesoft.org/schema/mule/documentation";
    private static final String DOCS_NAMESPACE_PREFIX = "doc";
    private static final Namespace DOCS_NAMESPACE = Namespace.getNamespace((String)"doc", (String)"http://www.mulesoft.org/schema/mule/documentation");

    public static void addVariableDeclarationFor(Element flow, List<String> uriParams) {
        if (!uriParams.isEmpty()) {
            Element transformNode = ApikitUriParamUtils.addTransformNodeAsFirstNodeTo(flow);
            Element variables = (Element)transformNode.getContent(0);
            for (String uriParam : uriParams) {
                ApikitUriParamUtils.addVariable(variables, uriParam);
            }
        }
    }

    private static Element addTransformNodeAsFirstNodeTo(Element flow) {
        Element result = ApikitUriParamUtils.createTransformNode();
        flow.addContent(0, (Content)result);
        return result;
    }

    private static Element createTransformNode() {
        Element result = new Element("transform").setName("transform").setNamespace(XmlDslUtils.CORE_EE_NAMESPACE).setAttribute("name", "URI Params to Variables", DOCS_NAMESPACE);
        result.addContent((Content)new Element("variables", XmlDslUtils.CORE_EE_NAMESPACE));
        return result;
    }

    private static void addVariable(Element variables, String uriParam) {
        Element variable = new Element("set-variable", XmlDslUtils.CORE_EE_NAMESPACE).setAttribute("variableName", uriParam);
        variable.addContent("attributes.uriParams." + uriParam);
        variables.addContent((Content)variable);
    }
}

