/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit.steps;

import com.mulesoft.tools.migration.library.apikit.ApikitUriParamUtils;
import com.mulesoft.tools.migration.library.apikit.steps.AbstractApikitMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class ApikitRouterConfig
extends AbstractApikitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='config' and namespace-uri()='http://www.mulesoft.org/schema/mule/mule-apikit']";
    private static final String FLOW_XPATH_SELECTOR = "//*[@name='%s']";
    private static final String FLOW_MAPPING_PARENT_TAG_NAME = "flow-mappings";
    private static final String FLOW_MAPPING_TAG_NAME = "flow-mapping";
    private static final String FLOW_REF_ATTRIBUTE = "flow-ref";
    private static final String RESOURCE_ATTRIBUTE = "resource";

    public String getDescription() {
        return "Update APIkit config";
    }

    public ApikitRouterConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) {
        element.setAttribute("outboundHeadersMapName", "outboundHeaders");
        element.setAttribute("httpStatusVarName", "httpStatus");
        if (element.getAttribute("consoleEnabled") != null) {
            report.report(MigrationReport.Level.WARN, element, element.getParentElement(), "consoleEnabled property do not exist in Mule 4.", new String[0]);
            element.removeAttribute("consoleEnabled");
        }
        if (element.getAttribute("consolePath") != null) {
            report.report(MigrationReport.Level.WARN, element, element.getParentElement(), "consolePath property do not exist in Mule 4.", new String[0]);
            element.removeAttribute("consolePath");
        }
        if (element.getAttribute("extensionEnabled") != null) {
            report.report(MigrationReport.Level.WARN, element, element.getParentElement(), "extensionEnabled property do not exist in Mule 4.", new String[0]);
            element.removeAttribute("extensionEnabled");
        }
        this.migrateFlowMappings(element, report);
    }

    private void migrateFlowMappings(Element config, MigrationReport report) {
        List<Element> flowMappings = config.getChildren().stream().filter(child -> "apikit".equals(child.getNamespacePrefix()) && FLOW_MAPPING_TAG_NAME.equals(child.getName())).collect(Collectors.toList());
        if (!flowMappings.isEmpty()) {
            Element flowMappingParent = this.getFlowMappingsParent(config);
            flowMappings.forEach(flowMapping -> {
                flowMapping.detach();
                flowMapping.setNamespace(APIKIT_NAMESPACE);
                flowMappingParent.addContent((Content)flowMapping);
                this.migrateUriParams((Element)flowMapping);
            });
        }
    }

    private void migrateUriParams(Element flowMapping) {
        Attribute flowRef = flowMapping.getAttribute(FLOW_REF_ATTRIBUTE);
        Attribute resourceUri = flowMapping.getAttribute(RESOURCE_ATTRIBUTE);
        Element flow = this.getApplicationModel().getNode(String.format(FLOW_XPATH_SELECTOR, flowRef.getValue()));
        if (flow != null && flowRef != null && resourceUri != null) {
            ArrayList<String> uriParams = new ArrayList<String>();
            Matcher m = Pattern.compile("\\{.*?\\}").matcher(resourceUri.getValue());
            while (m.find()) {
                String uriParam = m.group().replaceAll("\\{|\\}", "");
                uriParams.add(uriParam);
            }
            ApikitUriParamUtils.addVariableDeclarationFor(flow, uriParams);
        }
    }

    private Element getFlowMappingsParent(Element config) {
        Element flowMappingsParent = config.getChild(FLOW_MAPPING_PARENT_TAG_NAME, APIKIT_NAMESPACE);
        if (flowMappingsParent == null) {
            flowMappingsParent = new Element(FLOW_MAPPING_PARENT_TAG_NAME, APIKIT_NAMESPACE);
            config.addContent((Content)flowMappingsParent);
        }
        return flowMappingsParent;
    }
}

