/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class GatewayMigrationStep
extends AbstractApplicationModelMigrationStep {
    protected static final String SPACE = " ";
    protected static final String NAME_ATTR_NAME = "name";
    protected static final String EMPTY = "";
    private static final String MULE_4_TAG_NAME = "mule";
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String MULE_4_XSI_SCHEMA_LOCATION_URI = "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd";

    public GatewayMigrationStep(Namespace namespace, String tagName) {
        this.setNamespacesContributions(Arrays.asList(namespace));
        this.setAppliedTo(this.getXPathSelector(namespace, tagName));
    }

    public GatewayMigrationStep() {
    }

    protected void removeAttributes(List<String> attributesToRemove, Element element) {
        attributesToRemove.forEach(attr -> element.removeAttribute(attr));
    }

    protected final String getXPathSelector(Namespace namespace, String tagName) {
        return "//*[namespace-uri() = '" + namespace.getURI() + "' and local-name() = '" + tagName + "']";
    }

    protected final String getXPathSelector(Namespace namespace, String tagName, String attributeName, String attributeValue) {
        return "//*[namespace-uri() = '" + namespace.getURI() + "' and local-name() = '" + tagName + "'][@*[local-name()='" + attributeName + "' and .='" + attributeValue + "']]";
    }

    protected final String getXPathSelector(String attributeValue) {
        return "//*[@*[contains(.,'" + attributeValue + "')]]";
    }

    protected final List<Content> detachContent(List<Content> contentList) {
        ArrayList<Content> result = new ArrayList<Content>();
        int contentListSize = contentList.size();
        for (int i = 0; i < contentListSize; ++i) {
            Content c = contentList.get(0);
            result.add(c.detach());
        }
        return result;
    }

    protected void addSchemaLocationNamespace(Element root, String mule4Uri) {
        Attribute attr = this.getXSIAttribute(root);
        attr.setValue(attr.getValue() + SPACE + mule4Uri);
    }

    protected void removeSchemaLocationNamespace(Element root, String mule3Uri, String mule4Uri) {
        Attribute attr = this.getXSIAttribute(root);
        String uri = attr.getValue();
        if (uri.contains(mule4Uri)) {
            attr.setValue(uri.replace(mule3Uri, EMPTY));
        } else {
            attr.setValue(uri.replace(mule3Uri, mule4Uri));
        }
    }

    private void setUriValue(Attribute attr, String uri, String mule3Uri, String mule4Uri) {
        if (uri.contains(mule3Uri)) {
            attr.setValue(uri.replace(mule3Uri, mule4Uri));
        } else if (!uri.contains(mule4Uri)) {
            attr.setValue(uri + SPACE + mule4Uri);
        }
    }

    protected Attribute getXSIAttribute(Element element) {
        if (element == null) {
            return new Attribute(SCHEMA_LOCATION, MULE_4_XSI_SCHEMA_LOCATION_URI, GatewayNamespaces.XSI_NAMESPACE);
        }
        if (element.getAttribute(SCHEMA_LOCATION, GatewayNamespaces.XSI_NAMESPACE) == null) {
            Attribute attr = new Attribute(SCHEMA_LOCATION, MULE_4_XSI_SCHEMA_LOCATION_URI, GatewayNamespaces.XSI_NAMESPACE);
            element.setAttribute(attr);
            return attr;
        }
        return element.getAttribute(SCHEMA_LOCATION, GatewayNamespaces.XSI_NAMESPACE);
    }

    protected void replaceSchemaLocationNamespace(Element root, String mule3UriXsd, String mule4UriXsd, String mule3Uri, String mule4Uri) {
        Attribute attr = this.getXSIAttribute(root);
        this.setUriValue(attr, attr.getValue(), mule3UriXsd, mule4UriXsd);
        this.setUriValue(attr, attr.getValue(), mule3Uri, mule4Uri);
    }

    protected Element getRootElement(Element element) {
        Document doc = element.getDocument();
        if (doc != null) {
            return doc.getRootElement();
        }
        Element e = new Element(MULE_4_TAG_NAME, GatewayNamespaces.MULE_4_POLICY_NAMESPACE).addContent((Content)element);
        e.addNamespaceDeclaration(GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
        new Document().setRootElement(e);
        return e;
    }

    protected void migrateRootElement(Element element, Namespace mule3Namespace, Namespace mule4Namespace, String mule3UriXsd, String mule4UriXsd, String mule3Uri, String mule4Uri) {
        Element root = this.getRootElement(element);
        if (root != null) {
            root.removeNamespaceDeclaration(mule3Namespace);
            root.addNamespaceDeclaration(mule4Namespace);
            this.replaceSchemaLocationNamespace(root, mule3UriXsd, mule4UriXsd, mule3Uri, mule4Uri);
        }
    }

    protected void addNamespaceDeclaration(Element root, Namespace namespace, String schemaLocationUri) {
        if (root != null) {
            root.addNamespaceDeclaration(namespace);
            this.addSchemaLocationNamespace(root, schemaLocationUri);
        }
    }
}

