/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.clientidenforcement;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.FilterTagMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.clientidenforcement.ValidateClientProcessorChainTagMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Content;
import org.jdom2.Element;

public class ValidateClientTagMigrationStep
extends FilterTagMigrationStep {
    private static final String VALIDATE_CLIENT_TAG_NAME = "validate-client";
    private static final String VALIDATE_CLIENT_ID_TAG_NAME = "validate-client-id";
    private static final String VALIDATE_BASIC_AUTH_ENCODED_CLIENT_TAG_NAME = "validate-basic-auth-encoded-client";
    private static final String BASIC_AUTH_ENABLED_ATTR_NAME = "basicAuthEnabled";
    private static final String CLIENT_ID_ATTR_NAME = "clientId";
    private static final String CLIENT_SECRET_ATTR_NAME = "clientSecret";
    private static final String CONFIG = "config";
    private static final String CLIENT_ID_ENFORCEMENT_XSI_SCHEMA_LOCATION_URI_MULE4 = "http://www.mulesoft.org/schema/mule/client-id-enforcement http://www.mulesoft.org/schema/mule/client-id-enforcement/current/mule-client-id-enforcement.xsd";
    private static final String ON_UNACCEPTED_ATTR_NAME = "onUnaccepted";
    private static final String CONFIG_REF = "config-ref";
    private static final String CLIENT_ID_ENFORCEMENT_CONFIG = "clientEnforcementConfig";
    private static final String ENCODED_CLIENT = "encodedClient";
    private static final String ENCODED_CLIENT_VALUE = "#[attributes.headers.authorization]";
    private static final String TRUE = "true";

    public ValidateClientTagMigrationStep() {
        super(GatewayNamespaces.API_PLATFORM_GW_MULE_3_NAMESPACE, VALIDATE_CLIENT_TAG_NAME);
    }

    private void addConfigElement(Element root) {
        if (root != null && root.getChild(CONFIG, GatewayNamespaces.CLIENT_ID_ENFORCEMENT_NAMESPACE) == null) {
            this.addNamespaceDeclaration(root, GatewayNamespaces.CLIENT_ID_ENFORCEMENT_NAMESPACE, CLIENT_ID_ENFORCEMENT_XSI_SCHEMA_LOCATION_URI_MULE4);
            root.addContent(0, (Content)new Element(CONFIG, GatewayNamespaces.CLIENT_ID_ENFORCEMENT_NAMESPACE).setAttribute("name", CLIENT_ID_ENFORCEMENT_CONFIG));
        }
    }

    private void onValidMigrationElement(Element element, MigrationReport migrationReport) {
        element.setNamespace(GatewayNamespaces.CLIENT_ID_ENFORCEMENT_NAMESPACE);
        Element root = this.getRootElement(element);
        this.addConfigElement(root);
        String onUnacceptedName = element.getAttributeValue(ON_UNACCEPTED_ATTR_NAME);
        if (root != null && this.hasProcessorChain(root, onUnacceptedName)) {
            this.migrateProcessorChain(root, onUnacceptedName, migrationReport);
        }
        element.removeAttribute(ON_UNACCEPTED_ATTR_NAME);
        element.setAttribute(CONFIG_REF, CLIENT_ID_ENFORCEMENT_CONFIG);
    }

    private void migrateNonBasicAuthElement(Element element, MigrationReport migrationReport) {
        if (element.getAttribute(CLIENT_SECRET_ATTR_NAME) != null) {
            this.onValidMigrationElement(element, migrationReport);
        } else if (element.getAttribute(CLIENT_ID_ATTR_NAME) != null) {
            element.setName(VALIDATE_CLIENT_ID_TAG_NAME);
            this.onValidMigrationElement(element, migrationReport);
        } else {
            migrationReport.report("clientIdEnforcement.invalidMigrationElement", element, element, new String[0]);
        }
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        if (element.getAttribute(BASIC_AUTH_ENABLED_ATTR_NAME) != null) {
            if (element.getAttributeValue(BASIC_AUTH_ENABLED_ATTR_NAME).equals(TRUE)) {
                element.setName(VALIDATE_BASIC_AUTH_ENCODED_CLIENT_TAG_NAME);
                element.removeAttribute(BASIC_AUTH_ENABLED_ATTR_NAME);
                element.setAttribute(ENCODED_CLIENT, ENCODED_CLIENT_VALUE);
                this.onValidMigrationElement(element, migrationReport);
            } else {
                element.removeAttribute(BASIC_AUTH_ENABLED_ATTR_NAME);
                this.migrateNonBasicAuthElement(element, migrationReport);
            }
        } else {
            this.migrateNonBasicAuthElement(element, migrationReport);
        }
    }

    @Override
    protected void migrateProcessorChain(Element root, String onUnacceptedName, MigrationReport migrationReport) {
        ValidateClientProcessorChainTagMigrationStep step = new ValidateClientProcessorChainTagMigrationStep(onUnacceptedName);
        step.setApplicationModel(this.getApplicationModel());
        step.execute(this.getProcessorChain(root, onUnacceptedName), migrationReport);
    }
}

