/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.proxy;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.proxy.ProxyPomContributionMigrationStep;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class DWWsdlPropertyAttributeValueMigrationStep
extends GatewayMigrationStep {
    private static final String WSDL_PROPERTY_ATTRIBUTE_VALUE_START = "![wsdl(p[";
    private static final String HOST = "host";
    private static final String PATH = "path";
    private static final String PORT = "port";
    private static final String NAMESPACE = "namespace";
    private static final String SERVICE = "service";
    private static final String DW_WSDL_START = "#[Wsdl::";
    private static final String DW_WSDL_END = "}','${service.name}','${service.port}')]";
    private static final String ADDRESSES_0 = "addresses[0]";
    private static final String GET_PORT = "getPort";
    private static final String GET_HOST = "getHost";
    private static final String GET_PATH = "getPath";
    private static final String NAME = "name";

    public DWWsdlPropertyAttributeValueMigrationStep() {
        this.setAppliedTo(this.getXPathSelector(WSDL_PROPERTY_ATTRIBUTE_VALUE_START));
    }

    private String extractWsdlLocationProperty(String attributeValue) {
        return attributeValue.substring(10, attributeValue.indexOf("']"));
    }

    private void setFunctionAttributeValue(Element element, MigrationReport migrationReport, String attributeName, String mule3AttributeValue, String getValue) {
        element.setAttribute(attributeName, DW_WSDL_START + getValue + "('${" + this.extractWsdlLocationProperty(mule3AttributeValue) + DW_WSDL_END);
        migrationReport.report("proxy.functionWsdlPropertyAttribute", element, element, new String[]{mule3AttributeValue});
    }

    private String getPropertyAttributeValue(String value) {
        return "service." + value;
    }

    private void setAttributeValue(Element element, MigrationReport migrationReport, String attributeName, String mule3AttributeValue, String mule4AttributeValue) {
        element.setAttribute(attributeName, "${" + mule4AttributeValue + "}");
        migrationReport.report("proxy.wsdlPropertyAttribute", element, element, new String[]{mule3AttributeValue, mule4AttributeValue});
    }

    private void replaceValue(Element element, MigrationReport migrationReport, Attribute attribute) {
        String name;
        switch (name = attribute.getName()) {
            case "host": {
                this.setFunctionAttributeValue(element, migrationReport, HOST, element.getAttributeValue(HOST), GET_HOST);
                break;
            }
            case "port": {
                if (attribute.getValue().contains(ADDRESSES_0)) {
                    this.setFunctionAttributeValue(element, migrationReport, PORT, element.getAttributeValue(PORT), GET_PORT);
                    break;
                }
                this.setAttributeValue(element, migrationReport, PORT, attribute.getValue(), this.getPropertyAttributeValue(PORT));
                break;
            }
            case "path": {
                this.setFunctionAttributeValue(element, migrationReport, PATH, element.getAttributeValue(PATH), GET_PATH);
                break;
            }
            case "namespace": {
                this.setAttributeValue(element, migrationReport, NAMESPACE, attribute.getValue(), this.getPropertyAttributeValue(NAMESPACE));
                break;
            }
            case "service": {
                this.setAttributeValue(element, migrationReport, SERVICE, attribute.getValue(), this.getPropertyAttributeValue(NAME));
                break;
            }
            default: {
                migrationReport.report("proxy.unknownAttributeValue", attribute.getParent(), attribute.getParent(), new String[]{name});
            }
        }
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        new ProxyPomContributionMigrationStep(false).execute((PomModel)this.getApplicationModel().getPomModel().get(), migrationReport);
        element.getAttributes().stream().filter(attr -> attr.getValue().startsWith(WSDL_PROPERTY_ATTRIBUTE_VALUE_START)).forEach(attribute -> this.replaceValue(element, migrationReport, (Attribute)attribute));
    }
}

