/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.NamespaceContribution;
import com.mulesoft.tools.migration.xml.AdditionalNamespacesFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jdom2.Document;
import org.jdom2.Namespace;

public class PreprocessNamespaces
implements NamespaceContribution {
    public String getDescription() {
        return "Check components with no migration defined.";
    }

    public void execute(ApplicationModel applicationModel, MigrationReport report) throws RuntimeException {
        List<Document> documents = applicationModel.getApplicationDocuments().values().stream().collect(Collectors.toList());
        documents.forEach(d -> this.addReportEntries((Document)d, report, applicationModel));
    }

    public void addReportEntries(Document document, MigrationReport report, ApplicationModel applicationModel) {
        List<Namespace> unsupportedNamespaces = document.getRootElement().getAdditionalNamespaces().stream().filter(n -> !ApplicationModel.getElementsWithNamespace((Document)document, (Namespace)n, (ApplicationModel)applicationModel).isEmpty() && !AdditionalNamespacesFactory.containsNamespace((Namespace)n, (List)applicationModel.getSupportedNamespaces())).collect(Collectors.toList());
        AtomicInteger processedElements = new AtomicInteger(0);
        unsupportedNamespaces.forEach(ns -> applicationModel.getNodes("//*[namespace-uri() = '" + ns.getURI() + "' and namespace-uri(..) != '" + ns.getURI() + "']").forEach(node -> {
            processedElements.incrementAndGet();
            if (ns.getURI().startsWith("http://www.mulesoft.org")) {
                report.report("components.unsupported", node, node, new String[]{ns.getPrefix()});
            } else {
                report.report("components.unknown", node, node, new String[]{ns.getPrefix(), ns.getURI(), "mule.migration.additionalSpringNamespaces"});
            }
            report.addComponentFailure(node);
        }));
        report.addProcessedElements(processedElements.get());
    }
}

