/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import org.jdom2.Content;
import org.jdom2.Element;

public class ScatterGather
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//mule:*[local-name()='scatter-gather' or local-name()='all']";

    public String getDescription() {
        return "Migrate Scatter Gather.";
    }

    public ScatterGather() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        if (element.getName().equals("all")) {
            element.setName("scatter-gather");
        }
        ArrayList childs = new ArrayList(element.getChildren());
        childs.forEach(c -> {
            if (c.getName().equals("processor-chain")) {
                c.setName("route");
            } else if (c.getName().equals("threading-profile")) {
                report.report("scatterGather.threading", c, element, new String[0]);
                c.detach();
            } else if (c.getName().equals("custom-aggregation-strategy")) {
                report.report("scatterGather.customAggregation", c, element, new String[0]);
            } else {
                Element newRouteElement = new Element("route", element.getNamespace());
                Integer childIndex = element.indexOf((Content)c);
                c.detach();
                newRouteElement.addContent((Content)c);
                element.addContent(childIndex.intValue(), (Content)newRouteElement);
            }
        });
    }
}

