/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class RegexFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"regex-filter");

    @Override
    public String getDescription() {
        return "Update Regex filter to a validation.";
    }

    public RegexFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        this.addValidationsModule(element.getDocument());
        Attribute attrPattern = element.getAttribute("pattern");
        if (!attrPattern.getValue().endsWith(".*")) {
            attrPattern.setValue(attrPattern.getValue() + ".*");
        }
        if (!attrPattern.getValue().startsWith(".*")) {
            attrPattern.setValue(".*" + attrPattern.getValue());
        }
        attrPattern.setName("regex");
        if (element.getAttribute("value") == null) {
            element.setAttribute("value", "#[payload]");
        }
        element.setName("matches-regex");
        element.setNamespace(VALIDATION_NAMESPACE);
        this.handleFilter(element);
    }
}

