/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Element;

public class WildcardFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"wildcard-filter");

    @Override
    public String getDescription() {
        return "Update Wildcard filter to a validation.";
    }

    public WildcardFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        this.addValidationsModule(element.getDocument());
        element.setAttribute("regex", "^" + element.getAttributeValue("pattern").replaceAll("\\*", ".*") + "$");
        element.removeAttribute("pattern");
        element.setAttribute("value", "#[payload]");
        element.setName("matches-regex");
        element.setNamespace(VALIDATION_NAMESPACE);
        this.handleFilter(element);
    }
}

