/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.db;

import com.mulesoft.tools.migration.library.mule.steps.db.AbstractDbOperationMigrator;
import com.mulesoft.tools.migration.library.tools.mel.DefaultMelCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Element;

public class DbStoredProcedure
extends AbstractDbOperationMigrator {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/db' and local-name() = 'stored-procedure']";

    public String getDescription() {
        return "Update call stored procedure operation of the DB Connector.";
    }

    public DbStoredProcedure() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        this.migrateSql(object);
        this.migrateInputParamTypes(object);
        this.migrateInputParams(object);
        List outParams = object.getChildren("out-param", DB_NAMESPACE).stream().map(ip -> new Element("output-parameter", DB_NAMESPACE).setAttribute("key", ip.getAttributeValue("name"))).collect(Collectors.toList());
        if (!outParams.isEmpty()) {
            object.addContent((Content)new Element("output-parameters", DB_NAMESPACE).addContent(outParams));
        }
        object.removeChildren("out-param", DB_NAMESPACE);
        List inoutParams = object.getChildren("inout-param", DB_NAMESPACE).stream().map(ip -> new Element("in-out-parameter", DB_NAMESPACE).setAttribute("key", ip.getAttributeValue("name")).setAttribute("value", ip.getAttributeValue("value"))).collect(Collectors.toList());
        if (!inoutParams.isEmpty()) {
            object.addContent((Content)new Element("in-out-parameters", DB_NAMESPACE).addContent(inoutParams));
        }
        object.removeChildren("inout-param", DB_NAMESPACE);
        if (object.getAttribute("streaming") == null || "false".equals(object.getAttributeValue("streaming"))) {
            report.report("db.streaming", object, object, new String[0]);
        }
        object.removeAttribute("streaming");
        if (object.getAttribute("source") != null) {
            report.report("db.source", object, object, new String[0]);
            object.removeAttribute("source");
        }
        XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)false, (ExpressionMigrator)this.getExpressionMigrator(), (CompatibilityResolver)new DefaultMelCompatibilityResolver());
    }
}

