/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.email;

import com.mulesoft.tools.migration.library.mule.steps.email.Pop3InboundEndpoint;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Pop3sInboundEndpoint
extends Pop3InboundEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/pop3s' and local-name()='inbound-endpoint'][1]";

    @Override
    public String getDescription() {
        return "Update Pop3s transport inbound endpoint.";
    }

    public Pop3sInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Optional<Element> pop3sConnector = object.getAttribute("connector-ref") != null ? Optional.of(this.getConnector(object.getAttributeValue("connector-ref"))) : this.getDefaultConnector();
        super.execute(object, report);
        Element pop3sConnection = this.getApplicationModel().getNode("/*/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'pop3-config' and @name = '" + object.getAttributeValue("config-ref") + "']/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'pop3s-connection']");
        if (pop3sConnector.isPresent() && pop3sConnection.getChild("context", TLS_NAMESPACE) == null) {
            Element tlsClient;
            Element tlsContext = new Element("context", TLS_NAMESPACE);
            boolean tlsConfigured = false;
            Namespace pop3sNamespace = Namespace.getNamespace((String)"pop3s", (String)"http://www.mulesoft.org/schema/mule/pop3s");
            Element tlsKeyStore = pop3sConnector.get().getChild("tls-client", pop3sNamespace);
            if (tlsKeyStore != null) {
                Element keyStore = new Element("key-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyPassword");
                if (tlsKeyStore.getAttribute("class") != null) {
                    report.report("email.pop3KeyStoreClass", tlsKeyStore, tlsKeyStore, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"type", (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyAlias", (String)"alias");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"algorithm");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if ((tlsClient = pop3sConnector.get().getChild("tls-trust-store", pop3sNamespace)) != null) {
                Element keyStore = new Element("trust-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"storePassword", (String)"password");
                if (tlsClient.getAttribute("class") != null) {
                    report.report("email.pop3TlsClientClass", tlsClient, tlsClient, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"type", (String)"type");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if (tlsConfigured) {
                this.getApplicationModel().addNameSpace(TLS_NAMESPACE.getPrefix(), TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
                pop3sConnection.addContent((Content)tlsContext);
            }
        }
    }

    @Override
    protected Element createConnection() {
        return new Element("pop3s-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Element getConnection(Element m4Config) {
        return m4Config.getChild("pop3s-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/pop3s' and (local-name()='connector' or local-name()='gmail-connector') and @name = '" + connectorName + "']");
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/pop3s' and (local-name()='connector' or local-name()='gmail-connector')]");
    }
}

