/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.google.common.collect.ImmutableList;
import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HttpConnectorListener
extends AbstractHttpConnectorMigrationStep {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='listener']";

    public String getDescription() {
        return "Update HTTP listener source.";
    }

    public HttpConnectorListener() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element errorResponse;
        Element response;
        HttpConnectorListener.httpListenerLib(this.getApplicationModel());
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        object.setNamespace(HTTP_NAMESPACE);
        if (object.getAttribute("parseRequest") != null && !"false".equals(object.getAttributeValue("parseRequest"))) {
            report.report("http.parseRequest", object, object, new String[0]);
        }
        object.removeAttribute("parseRequest");
        XmlDslUtils.migrateSourceStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report);
        HttpConnectorListener.addAttributesToInboundProperties(object, this.getApplicationModel(), report);
        object.getChildren().forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.executeChild((Element)c, report, HTTP_NAMESPACE);
            }
        });
        if (object.getChild("response", HTTP_NAMESPACE) == null) {
            response = new Element("response", HTTP_NAMESPACE);
            object.addContent(0, (Content)response.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), HTTP_NAMESPACE)));
        }
        if ((response = object.getChild("response", HTTP_NAMESPACE)).getAttribute("statusCode") == null) {
            response.setAttribute("statusCode", "#[migration::HttpListener::httpListenerResponseSuccessStatusCode(vars)]");
            report.report("http.statusCode", response, response, new String[0]);
        }
        if (object.getChild("error-response", HTTP_NAMESPACE) == null) {
            errorResponse = new Element("error-response", HTTP_NAMESPACE);
            object.addContent((Content)errorResponse.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), HTTP_NAMESPACE)));
        }
        if ((errorResponse = object.getChild("error-response", HTTP_NAMESPACE)).getAttribute("statusCode") == null) {
            errorResponse.setAttribute("statusCode", "#[vars.statusCode default migration::HttpListener::httpListenerResponseErrorStatusCode(vars)]");
            report.report("http.statusCode", errorResponse, errorResponse, new String[0]);
        }
    }

    public static void addAttributesToInboundProperties(Element object, ApplicationModel appModel, MigrationReport report) {
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("http.listener.path", "message.attributes.listenerPath");
        expressionsPerProperty.put("http.context.path", "if (endsWith(message.attributes.listenerPath, '/*')) message.attributes.listenerPath[0 to -3] default '/' else message.attributes.listenerPath");
        expressionsPerProperty.put("http.relative.path", "message.attributes.requestPath[1 + sizeOf(if (endsWith(message.attributes.listenerPath, '/*')) message.attributes.listenerPath[0 to -3] default '/' else message.attributes.listenerPath) to -1]");
        expressionsPerProperty.put("http.version", "message.attributes.version");
        expressionsPerProperty.put("http.scheme", "message.attributes.scheme");
        expressionsPerProperty.put("http.method", "message.attributes.method");
        expressionsPerProperty.put("http.request.uri", "message.attributes.requestUri");
        expressionsPerProperty.put("http.query.string", "message.attributes.queryString");
        expressionsPerProperty.put("http.remote.address", "message.attributes.remoteAddress");
        expressionsPerProperty.put("http.client.cert", "message.attributes.clientCertificate");
        expressionsPerProperty.put("LOCAL_CERTIFICATES", "[message.attributes.clientCertificate]");
        expressionsPerProperty.put("PEER_CERTIFICATES", "[message.attributes.clientCertificate]");
        expressionsPerProperty.put("http.query.params", "message.attributes.queryParams");
        expressionsPerProperty.put("http.uri.params", "message.attributes.uriParams");
        expressionsPerProperty.put("http.request", "message.attributes.requestPath");
        expressionsPerProperty.put("http.request.path", "message.attributes.requestPath");
        expressionsPerProperty.put("http.headers", "message.attributes.headers");
        try {
            InboundPropertiesHelper.addAttributesMapping(appModel, "org.mule.extension.http.api.HttpRequestAttributes", expressionsPerProperty, "message.attributes.headers mapObject ((value, key, index) -> { (if(upper(key as String) startsWith 'X-MULE_') upper((key as String) [2 to -1]) else key) : value })", "message.attributes.queryParams");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeChild(Element object, MigrationReport report, Namespace httpNamespace) throws RuntimeException {
        object.getChildren().forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.executeChild((Element)c, report, httpNamespace);
            }
        });
        if ("response-builder".equals(object.getName())) {
            HttpConnectorListener.handleReferencedResponseBuilder(object, this.getApplicationModel(), httpNamespace);
            object.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), httpNamespace));
            object.setName("response");
        }
        if ("error-response-builder".equals(object.getName())) {
            HttpConnectorListener.handleReferencedResponseBuilder(object, this.getApplicationModel(), httpNamespace);
            object.addContent((Content)HttpConnectorListener.compatibilityHeaders(this.getApplicationModel(), httpNamespace));
            object.setName("error-response");
        }
    }

    public static Element compatibilityHeaders(ApplicationModel appModel, Namespace httpNamespace) {
        return XmlDslUtils.setText((Element)new Element("headers", httpNamespace), (String)"#[migration::HttpListener::httpListenerResponseHeaders(vars)]");
    }

    public static void httpListenerLib(ApplicationModel appModel) {
        try {
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath()), "HttpListener.dwl", "/**" + System.lineSeparator() + " * Emulates the response headers building logic of the Mule 3.x HTTP Connector." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpListenerResponseHeaders(vars: {}) = do {" + System.lineSeparator() + "    var matcher_regex = /(?i)http\\..*|Connection|Transfer-Encoding/" + System.lineSeparator() + "    ---" + System.lineSeparator() + "    vars.compatibility_outboundProperties default {} filterObject" + System.lineSeparator() + "        ((value,key) -> not ((key as String) matches matcher_regex))" + System.lineSeparator() + "        mapObject ((value, key, index) -> {" + System.lineSeparator() + "            (if (upper(key as String) startsWith 'MULE_') upper('X-' ++ key as String) else key) : value" + System.lineSeparator() + "        })" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator() + "/**" + System.lineSeparator() + " * Emulates the success status code logic of the Mule 3.x HTTP Connector." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpListenerResponseSuccessStatusCode(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties['http.status'] default 200" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator() + "/**" + System.lineSeparator() + " * Emulates the error status code logic of the Mule 3.x HTTP Connector." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpListenerResponseErrorStatusCode(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties['http.status']" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handleReferencedResponseBuilder(Element object, ApplicationModel appModel, Namespace httpNamespace) {
        Element builderRef = object.getChild("builder", httpNamespace);
        int idx = 0;
        while (builderRef != null) {
            object.removeContent((Content)builderRef);
            Element builder = appModel.getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='response-builder' and @name='" + builderRef.getAttributeValue("ref") + "']");
            HttpConnectorListener.handleReferencedResponseBuilder(builder, appModel, httpNamespace);
            ImmutableList builderContent = ImmutableList.copyOf((Collection)builder.getChildren()).asList();
            builder.setContent(Collections.emptyList());
            object.addContent(idx, (Collection)builderContent);
            idx += builderContent.size();
            builderRef = object.getChild("builder", httpNamespace);
        }
    }
}

