/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.json;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.library.mule.steps.json.JsonMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class JsonSchemaValidationFilter
extends AbstractFilterMigrator
implements JsonMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/json' and local-name()='json-schema-validation-filter']";

    @Override
    public String getDescription() {
        return "Migrate deprecated JSON Schema validation filter";
    }

    public JsonSchemaValidationFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{JSON_NAMESPACE}));
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        element.setName("validate-schema");
        Attribute schemaLocations = element.getAttribute("schemaLocations");
        schemaLocations.setName("schema");
        String[] locations = schemaLocations.getValue().split(",");
        if (locations.length > 1) {
            for (String location : locations) {
                element.getParentElement().addContent(element.getParentElement().indexOf((Content)element), (Content)element.clone().setAttribute("schema", location));
            }
            this.handleFilter(element);
            element.detach();
        } else {
            this.handleFilter(element);
        }
    }
}

