/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.quartz;

import com.mulesoft.tools.migration.library.mule.steps.jms.AbstractJmsEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.jms.JmsOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.vm.AbstractVmEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.vm.VmOutboundEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.AbstractGlobalEndpointMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class QuartzInboundEndpoint
extends AbstractApplicationModelMigrationStep {
    protected static final String QUARTZ_NS_PREFIX = "quartz";
    protected static final String QUARTZ_NS_URI = "http://www.mulesoft.org/schema/mule/quartz";
    private static final Namespace QUARTZ_NS = Namespace.getNamespace((String)"quartz", (String)"http://www.mulesoft.org/schema/mule/quartz");
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/quartz' and local-name() = 'inbound-endpoint'][1]";

    public String getDescription() {
        return "Update quartz inbound endpoints.";
    }

    public QuartzInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element endpointPollingJob;
        String payload;
        Element eventGeneratorJob;
        if (object.removeAttribute("repeatCount")) {
            report.report("quartz.repeatCount", object, object, new String[0]);
        }
        object.setName("scheduler");
        object.setNamespace(XmlDslUtils.CORE_NAMESPACE);
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        String configName = object.getAttributeValue("connector-ref");
        Optional config = configName != null ? this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/quartz' and local-name() = 'connector' and @name = '" + configName + "']") : this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/quartz' and local-name() = 'connector']");
        config.ifPresent(cfg -> {
            Element receiverThreadingProfile = cfg.getChild("receiver-threading-profile", XmlDslUtils.CORE_NAMESPACE);
            if (receiverThreadingProfile != null && receiverThreadingProfile.getAttribute("maxThreadsActive") != null) {
                XmlDslUtils.getContainerElement((Element)object).setAttribute("maxConcurrency", receiverThreadingProfile.getAttributeValue("maxThreadsActive"));
            }
        });
        Element schedulingStrategy = new Element("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE);
        Element fixedFrequecy = null;
        Element cron = null;
        if (object.getAttribute("repeatInterval") != null) {
            if (fixedFrequecy == null) {
                fixedFrequecy = new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE);
                schedulingStrategy.addContent((Content)fixedFrequecy);
            }
            fixedFrequecy.setAttribute("frequency", object.getAttributeValue("repeatInterval"));
            object.removeAttribute("repeatInterval");
        }
        if (object.getAttribute("startDelay") != null) {
            if (fixedFrequecy == null) {
                fixedFrequecy = new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE);
                schedulingStrategy.addContent((Content)fixedFrequecy);
            }
            fixedFrequecy.setAttribute("startDelay", object.getAttributeValue("startDelay"));
            object.removeAttribute("startDelay");
        }
        if (object.getAttribute("cronExpression") != null) {
            if (cron == null) {
                cron = new Element("cron", XmlDslUtils.CORE_NAMESPACE);
                schedulingStrategy.addContent((Content)cron);
            }
            cron.setAttribute("expression", object.getAttributeValue("cronExpression"));
            object.removeAttribute("cronExpression");
        }
        if (object.getAttribute("cronTimeZone") != null) {
            if (cron == null) {
                cron = new Element("cron", XmlDslUtils.CORE_NAMESPACE);
                schedulingStrategy.addContent((Content)cron);
            }
            cron.setAttribute("timeZone", object.getAttributeValue("cronTimeZone"));
            object.removeAttribute("cronTimeZone");
        }
        if ((eventGeneratorJob = object.getChild("event-generator-job", QUARTZ_NS)) != null && (payload = eventGeneratorJob.getChildText("payload", QUARTZ_NS)) != null) {
            XmlDslUtils.addElementAfter((Element)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", payload), (Element)object);
        }
        if ((endpointPollingJob = object.getChild("endpoint-polling-job", QUARTZ_NS)) != null) {
            Element jobEndpoint = endpointPollingJob.getChild("job-endpoint", QUARTZ_NS);
            XmlDslUtils.addMigrationAttributeToElement((Element)jobEndpoint, (Attribute)new Attribute("isPolledConsumer", "true"));
            if (JobEndpointMigrableConnector.JMS.equals((Object)this.resolveEndpointConnector(jobEndpoint))) {
                this.handleGlobalEndpointsRefs(jobEndpoint);
                Optional<Element> jobEndpointConnector = AbstractJmsEndpoint.resolveJmsConnector(jobEndpoint, this.getApplicationModel());
                jobEndpointConnector.ifPresent(c -> jobEndpoint.setAttribute("connector-ref", c.getAttributeValue("name")));
                this.getApplicationModel();
                ApplicationModel.addNameSpace((Namespace)AbstractJmsEndpoint.JMS_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/jms/current/mule-jms.xsd", (Document)object.getDocument());
                jobEndpoint.setNamespace(AbstractJmsEndpoint.JMS_NAMESPACE);
                jobEndpoint.setName("consume");
                String jmsConfig = AbstractJmsEndpoint.migrateJmsConfig(jobEndpoint, report, jobEndpointConnector, this.getApplicationModel());
                JmsOutboundEndpoint.migrateOutboundJmsEndpoint(jobEndpoint, report, jobEndpointConnector, jmsConfig, this.getApplicationModel());
                jobEndpoint.detach();
                XmlDslUtils.addElementAfter((Element)jobEndpoint, (Element)object);
                if (object.getAttribute("timeout") != null) {
                    jobEndpoint.addContent((Content)new Element("consume-configuration", AbstractJmsEndpoint.JMS_NAMESPACE).setAttribute("maximumWait", object.getAttributeValue("timeout")));
                }
                TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)jobEndpoint, (MigrationReport)report, (boolean)true);
                TransportsUtils.extractInboundChildren((Element)jobEndpoint, (int)(jobEndpoint.getParentElement().indexOf((Content)jobEndpoint) + 2), (Element)jobEndpoint.getParentElement(), (ApplicationModel)this.getApplicationModel());
                AbstractJmsEndpoint.addAttributesToInboundProperties(jobEndpoint, this.getApplicationModel(), report);
                object.addContent((Content)schedulingStrategy);
            } else if (JobEndpointMigrableConnector.VM.equals((Object)this.resolveEndpointConnector(jobEndpoint))) {
                this.handleGlobalEndpointsRefs(jobEndpoint);
                Optional<Element> jobEndpointConnector = AbstractVmEndpoint.resolveVmConector(jobEndpoint, this.getApplicationModel());
                jobEndpointConnector.ifPresent(c -> jobEndpoint.setAttribute("connector-ref", c.getAttributeValue("name")));
                this.getApplicationModel();
                ApplicationModel.addNameSpace((Namespace)AbstractVmEndpoint.VM_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/vm/current/mule-vm.xsd", (Document)object.getDocument());
                jobEndpoint.setNamespace(AbstractVmEndpoint.VM_NAMESPACE);
                jobEndpoint.setName("consume");
                String vmConfigName = AbstractVmEndpoint.getVmConfigName(object, jobEndpointConnector);
                Element vmConfig = AbstractVmEndpoint.migrateVmConfig(object, jobEndpointConnector, vmConfigName, this.getApplicationModel());
                VmOutboundEndpoint.migrateVmEndpointConsumer(jobEndpoint, report, jobEndpointConnector, vmConfigName, vmConfig);
                jobEndpoint.detach();
                XmlDslUtils.addElementAfter((Element)jobEndpoint, (Element)object);
                if (object.getAttribute("timeout") != null) {
                    jobEndpoint.setAttribute("timeout", object.getAttributeValue("timeout"));
                    jobEndpoint.setAttribute("timeoutUnit", "MILLISECONDS");
                    object.removeAttribute("timeout");
                }
                TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)jobEndpoint, (MigrationReport)report, (boolean)true, (boolean)true);
                TransportsUtils.extractInboundChildren((Element)jobEndpoint, (int)(jobEndpoint.getParentElement().indexOf((Content)jobEndpoint) + 2), (Element)jobEndpoint.getParentElement(), (ApplicationModel)this.getApplicationModel());
                object.addContent((Content)schedulingStrategy);
            } else if (JobEndpointMigrableConnector.POLLING.equals((Object)this.resolveEndpointConnector(jobEndpoint))) {
                jobEndpoint.setName("inbound-endpoint");
                jobEndpoint.setNamespace(XmlDslUtils.CORE_NAMESPACE);
                jobEndpoint.detach();
                XmlDslUtils.addElementBefore((Element)jobEndpoint, (Element)object);
                jobEndpoint.addContent((Content)schedulingStrategy);
                object.detach();
            } else {
                object.addContent((Content)schedulingStrategy);
                report.report("quartz.unsupportedSource", jobEndpoint, object, new String[0]);
            }
        } else {
            object.addContent((Content)schedulingStrategy);
        }
        object.removeAttribute("connector-ref");
        object.removeAttribute("name");
        object.removeAttribute("jobName");
        object.removeContent((Filter)new ElementFilter(QUARTZ_NS));
    }

    private JobEndpointMigrableConnector resolveEndpointConnector(Element endpoint) {
        if (endpoint.getAttribute("address") != null) {
            String address = endpoint.getAttributeValue("address");
            if (address.startsWith("vm://")) {
                return JobEndpointMigrableConnector.VM;
            }
            if (address.startsWith("jms://")) {
                return JobEndpointMigrableConnector.JMS;
            }
            if (address.startsWith("imap://") || address.startsWith("imaps://") || address.startsWith("pop3://") || address.startsWith("pop3s://") || address.startsWith("file://") || address.startsWith("ftp://") || address.startsWith("sftp://")) {
                return JobEndpointMigrableConnector.POLLING;
            }
        }
        if (endpoint.getAttribute("ref") != null) {
            Element globalEndpoint = this.getApplicationModel().getNode("/*/*[@name = '" + endpoint.getAttributeValue("ref") + "']");
            return this.resolveEndpointConnector(globalEndpoint);
        }
        return JobEndpointMigrableConnector.OTHER;
    }

    protected void handleGlobalEndpointsRefs(Element endpoint) {
        if (endpoint.getAttribute("ref") != null) {
            Element globalEndpoint = this.getApplicationModel().getNode("/*/*[@name = '" + endpoint.getAttributeValue("ref") + "']");
            AbstractGlobalEndpointMigratorStep.copyAttributes((Element)globalEndpoint, (Element)endpoint);
            endpoint.removeAttribute("ref");
        }
    }

    private static enum JobEndpointMigrableConnector {
        JMS,
        VM,
        POLLING,
        OTHER;

    }
}

