/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceOperationMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RetrieveOperation
extends AbstractSalesforceOperationMigrationStep
implements ExpressionMigratorAware {
    private static final String name = "retrieve";

    public RetrieveOperation() {
        super(name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        super.execute(mule3Operation, report);
        SalesforceUtils.resolveTypeAttribute(mule3Operation, this.mule4Operation);
        this.setIdsAndFieldsElement(mule3Operation, this.mule4Operation);
        XmlDslUtils.addElementAfter((Element)this.mule4Operation, (Element)mule3Operation);
        mule3Operation.getParentElement().removeContent((Content)mule3Operation);
    }

    private void setIdsAndFieldsElement(Element mule3RetrieveOperation, Element mule4RetrieveOperation) {
        Optional<Element> ids = Optional.ofNullable(mule3RetrieveOperation.getChild("ids", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        Optional<Element> fields = Optional.ofNullable(mule3RetrieveOperation.getChild("fields", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        StringBuilder transformBody = new StringBuilder();
        fields.ifPresent(retrieveFields -> {
            Optional.ofNullable(retrieveFields.getAttributeValue("ref")).ifPresent(value -> {
                String expression = this.expressionMigrator.migrateExpression(value, true, retrieveFields);
                transformBody.append("fields: [" + this.expressionMigrator.unwrap(expression) + "]");
            });
            List fieldsChildren = retrieveFields.getChildren();
            if (fieldsChildren.size() > 0) {
                String filtersTransformBody = "fields: [" + fieldsChildren.stream().map(object -> object.getContent().stream().map(innerObject -> "\"" + innerObject.getValue() + "\"").collect(Collectors.joining(""))).collect(Collectors.joining(",")) + "]";
                transformBody.append(filtersTransformBody);
            }
            ids.ifPresent(retrieveIds -> {
                Optional.ofNullable(retrieveIds.getAttributeValue("ref")).ifPresent(value -> {
                    String expression = this.expressionMigrator.migrateExpression(value, true, retrieveIds);
                    if (transformBody != null && !transformBody.equals("")) {
                        transformBody.append(", \n");
                    }
                    transformBody.append("ids: [" + this.expressionMigrator.unwrap(expression) + "]");
                });
                List idsChildren = retrieveIds.getChildren();
                if (idsChildren.size() > 0) {
                    String idsTransformBody = "ids: [" + idsChildren.stream().map(object -> object.getContent().stream().map(innerObject -> "\"" + innerObject.getValue() + "\"").collect(Collectors.joining(""))).collect(Collectors.joining(",")) + "]";
                    if (transformBody != null && !transformBody.equals("")) {
                        transformBody.append(", \n");
                    }
                    transformBody.append(idsTransformBody);
                }
            });
            transformBody.insert(0, "%dw 2.0 output application/java\n---\n{\n");
            transformBody.append("\n} as Object { class : \"org.mule.extension.salesforce.api.core.RetrieveRequest\" }");
            SalesforceUtils.createTransformBeforeElement(mule3RetrieveOperation, transformBody.toString());
        });
    }
}

